/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___PPM_TYPES_H___
#define ___PPM_TYPES_H___

#define CACHE_SIZE	10

typedef struct ppm_cache {
	int		pc_h;
	unsigned char *	pc_line;
} PPM_CACHE;

typedef struct PPM_INFO {
	int		pi_fd;
	unsigned int	pi_offset;
	unsigned int	pi_lastacc;
	char		pi_type[4];
	unsigned int	pi_width;
	unsigned int	pi_height;
	int		pi_max;
	int		pi_write_offset;
	unsigned char *	pi_write;
	PPM_CACHE	pi_cache[CACHE_SIZE];
} PPM_INFO;

#define R	0
#define G	1
#define B	2

#define PIX(w,h,ww)	(((h)*(ww)+(w))*3)

int
ppm_converter(
	char * from_ppm,
	char * to_ppm,
	int width,
	int height,
	int (*func)(
		int * x,
		int * y,
		int * radius_width,
		int * radius_height,
		void * work),
	void * work);

#endif

