/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"ex_matrix.h"
#include	"xlerror.h"
#include	"xl.h"

XL_SEXP * xl_Melement();

void
init_Melement(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"Melement"),
		get_func_prim(xl_Melement,FO_APPLICATIVE,0,1,1));
}

XL_SEXP *
xl_Melement(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a,XL_SYM_FIELD * sf)
{
EX_MATRIX * ret;
XL_SEXP * _ret;
int size;
L_CHAR * _size;
int i;
	_size = get_sf_attribute(sf,l_string(std_cm,"size"));
	if ( _size == 0 )
		size = 1;
	else {
		size = atoi(n_string(std_cm,_size));
		if ( size <= 0 )
			size = 1;
	}
	ret = new_ex_matrix(size,size);
	for ( i = 0 ; i < size ; i ++ )
		XD(ret,i,i) = 1;
	_ret = get_sexp_from_ex(ret);
	free_ex_matrix(ret);
	return _ret;
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"Melement"),
		n_get_string("type missmatch"));
}

