//
// 
//	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
// 
//	This program is free software; you can redistribute it 
//	and/or modify it under the terms of the GLOBALBASE 
//	Library General Public License (G-LGPL) as published by 
//
//	http://www.globalbase.org/
// 
//	This program is distributed in the hope that it will be 
//	useful, but WITHOUT ANY WARRANTY; without even the 
//	implied warranty of MERCHANTABILITY or FITNESS FOR A 
//	PARTICULAR PURPOSE.
//
//

extern "C" {

#include <stdio.h>
#include <string.h>
#include	<AppConstants.h>

#include "long_char.h"
#include "v.h"
#include "memory_debug.h"

bool ConfirmBrowserSetup();
void SendQuit(OSType appSign);


#define ThrowIfErr_(a) if (OSErr err = (a)) throw err
#define netscape_reg "\pNetscape Registry"
#define netscape_pref "Netscape Preferences"
#define netscape_reg_target "ProfileLocation"
#define netscape_cosmos_info_target "user_pref(\"mime.text_gb.mac_appsig\", \"GBVI\");"
#define netscape_cosmos_info "user_pref(\"mime.text_gb.description\", \"COSMOS\");\nuser_pref(\"mime.text_gb.extension\", \"gb\");\nuser_pref(\"mime.text_gb.file_flags\", 0);\nuser_pref(\"mime.text_gb.latent_plug_in\", false);\nuser_pref(\"mime.text_gb.load_action\", 1);\nuser_pref(\"mime.text_gb.mac_appname\", \"COSMOS\");\nuser_pref(\"mime.text_gb.mac_appsig\", \"GBVI\");\nuser_pref(\"mime.text_gb.mac_filetype\", \"TEXT\");\nuser_pref(\"mime.text_gb.mac_plugin_name\", \"\");\nuser_pref(\"mime.text_gb.mimetype\", \"text/gb\");\n"

#pragma mark -
//=======================================================
//          read_file
//=======================================================


#define RF_BUFFER_SIZE 1024


typedef struct read_file {
	short	refNum;
	short counter;
	char buffer[RF_BUFFER_SIZE];
	long length;
	bool	eofFlag;
} read_file;

read_file *
start_read_file(short refNum)
{
	read_file * ret = new read_file;
	ret->refNum = refNum;
	ret->counter = 0;
	ret->length = RF_BUFFER_SIZE;
	ret->eofFlag = false;
	if ( FSRead(refNum, &ret->length, ret->buffer) == eofErr )
		ret->eofFlag = true;	
	return ret;
}

void
end_read_file(read_file * rf)
{
	delete rf;
}

bool
getchar_from_file(read_file * rf, char *dat)
{
	if ( rf->counter >= rf->length ) {
		if ( rf->eofFlag )
			return false;
		if ( FSRead(rf->refNum, &rf->length, rf->buffer) == eofErr )
			rf->eofFlag = 1;
		rf->counter = 1;
		*dat = rf->buffer[0];
		return true;
	}
	*dat = rf->buffer[rf->counter++];
	return true;
}



#pragma mark -
//=======================================================
//          change netscape settings
//=======================================================

void
location_utf8_2_sjis(char *location) {
	L_CHAR * target;
	extern VDISPLAY * disp_list;
	target=wct_conv(disp_list->wct, l_string(&utf8_cm, location));
	strcpy(location, n_string(std_cm, target));
	d_f_ree(target);
}


bool
netscape_open_reg(	short &prefRefNum,
				long &prefDirID,
				short &refNum	)
{
	try {
		ThrowIfErr_(FindFolder(kOnSystemDisk, 'pref', kDontCreateFolder, &prefRefNum, &prefDirID));
		ThrowIfErr_(HOpenDF(prefRefNum, prefDirID, netscape_reg, fsRdPerm, &refNum));
		return true;
	} catch (OSErr err) {
		printf("Error : %d\n", err);
		return false;
	}	
}


void
netscape_attach_pref(char profile_location[])
{
	FSSpec spec;
	short refNum;
	long count;
	int j;
	read_file * rf;
	char dat;
	char cmp[] = netscape_cosmos_info_target;
	short len = strlen(netscape_cosmos_info_target);

	printf("profile_location : %s\n", profile_location+1);
	
	if ( FSMakeFSSpec(0, 0, (unsigned char *)profile_location, &spec) != 0 ) {
		printf("Preferences file was not found\n");
		return;
	}
	
	if ( FSpOpenDF(&spec, fsRdWrPerm, &refNum) ) {
		printf("Cannot open the file.\n");
		return;
	}

	rf = start_read_file(refNum);
	while( getchar_from_file(rf, &dat) ) {
		for ( j = 0;  j < len;  j++ ) {
			if ( dat == cmp[j] ) {
				if ( ! getchar_from_file(rf, &dat) ) {
					end_read_file(rf);
					FSClose(refNum);
					return;
				}
			} else {
				break;
			}
		}
		if ( j == len ) {
			printf("COSMOS info found. OK.\n");
			FSClose(refNum);
			end_read_file(rf);
			return;
		}
	}
	FSClose(refNum);
	end_read_file(rf);

	printf("COSMOS info not found.\n");
 	if (ConfirmBrowserSetup()) {
		SendQuit(NetscapeSign);
		if ( FSpOpenDF(&spec, fsRdWrPerm, &refNum) ) {
			printf("Cannot open the file with write permission.\n");
			return;
		}
		SetFPos(refNum, fsFromLEOF, 0);
		count = strlen(netscape_cosmos_info);
		FSWrite(refNum, &count, netscape_cosmos_info);
	 	printf("Added settings.\n");
	}
	FSClose(refNum);
}

void
netscape_get_profile_location(short refNum)
{
	char location[512];
	char cmp[] = netscape_reg_target;
	short len = strlen(cmp);
	short j;
	read_file * rf = start_read_file(refNum);
	char dat;
	while( getchar_from_file(rf, &dat) ) {
		for ( j = 0;  j < len;  j++ ) {
			if ( dat == cmp[j] ) {
				if ( ! getchar_from_file(rf, &dat) ) {
					end_read_file(rf);
					return;
				}
			} else {
				break;
			}
		}
		if ( j == len ) {
			j = 1;
			// load the location
			while (1) {
				if ( ! getchar_from_file(rf, &dat) ) {
					end_read_file(rf);
					return;
				}
				if ( ! ( location[j++] = dat ) ) {
					location_utf8_2_sjis(location+1);
					strcat(location+1, ":");
					strcat(location+1, netscape_pref);
					location[0] = strlen(location+1);
					netscape_attach_pref(location);
					break;
				}
			}
		}
	}
}

void
netscape_change_settings()
{
	short prefRefNum;
	long prefDirID;
	short refNum;
	
	if ( netscape_open_reg(prefRefNum, prefDirID, refNum) ) {
		printf("Found Netscape Registry.\n");
		netscape_get_profile_location(refNum);
		FSClose(refNum);
	} else {
		printf("No Netscape Registry File.\n");
	}
}

} // extern "C"