/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef WIN32
#include	<sys/types.h>
// #include	<unistd.h>
#else
//#include	<winsock2.h>
#include <stdio.h>
#endif
#include	<stdlib.h>
#include	"memory_debug.h"
#include	"utils.h"
#include <windows.h>
#include "init.h"
extern int max_fid;
extern S_TABLE s_file_table;
extern int s_task_flag;

/*
int
launch_proc(
	char * str,
	char ** argv,
	STREAM ** stp,
	char * close_flags,
	char * ret_str_parent,
	char * ret_str_child)
{
int id;
int i,j;
char *fp,* org;
int len;
int p[2];
char ch;
int slen;

#ifndef WIN32
	pipe(p);
	id = fork1();
#endif
	if (id == 0 ) 
	{
 		close(p[1]);
		for ( len = 0 ; stp[len] ; len ++ );
		fp = d_alloc(len+4);
		org = d_alloc(len);
		for ( i = 0 ; i < len ; i ++ )
			org[i] = 0;
		for ( i = 0 ; i < len+4 ; i ++ )
			fp[i] = 0;
		for ( i = 0 ; i < len ; i ++ ) 
		{
			if ( stp[i]->h.tbl != &s_file_table )
				org[i] = 1;
			else if ( stp[i]->h.tbl == 0 )
				org[i] = 1;
			else if ( stp[i]->file.fid < len + 3 ) 
			{
				fp[stp[i]->file.fid] = 1;
				org[i] = 1;
			}
		}
		j = 0;
		for ( i = 3 ; i < 3 + len ; i ++ )
		{
			if ( fp[i] )
				continue;
			for ( ; j < len && org[j] ; j ++ );
			if ( j >= len )
				break;
			close(i);
			dup(stp[j]->file.fid);
			close(stp[j]->file.fid);
		}
		for ( ; i <= max_fid ; i ++ )
		{
			if ( p[0] == i )
				continue;
			close(i);
		}
		d_f_ree(fp);
		d_f_ree(org);
		if ( read(p[0],&ch,1) < 0 ) 
		{
			printf("pp p %i\n",p[0]);
			perror("launch");
		}
		close(p[0]);
		if ( ret_str_child ) {
			slen = strlen(ret_str_child);
			for ( i = 3 ; i < 3 + len ; i ++ )
				write(i,ret_str_child,slen);
		}
		execvp(str,argv);
		exit(1);
	}
	close(p[0]);
	if ( id == -1 )
	{
		close(p[1]);
		return -1;
	}
	if ( ret_str_parent )
		slen = strlen(ret_str_parent);
	for ( ; *stp ; stp ++ , close_flags ++ ) {
		if ( ret_str_parent )
			s_write(*stp,ret_str_parent,slen);
		if ( *close_flags )
			s_close(*stp);
	}
	write(p[1],&ch,1);
	close(p[1]);
	return id;
}
*/

int
launch_proc(
	char * str,
	char ** argv,
	STREAM ** stp,
	char * close_flags,
	char * ret_str_parent,
	char * ret_str_child)
{
int i,j,k;
int slen;
char ch;

PROCESS_INFORMATION  pi;
STARTUPINFO  si;
char * FullPath;
int IsSuccess = 0;
	
    memset(&si, 0, sizeof(STARTUPINFO));
    si.cb = sizeof(STARTUPINFO);
    si.dwFlags = STARTF_USESTDHANDLES;
    si.hStdInput = GetStdHandle(STD_INPUT_HANDLE);
    si.hStdOutput = GetStdHandle(STD_OUTPUT_HANDLE);
    si.hStdError = GetStdHandle(STD_ERROR_HANDLE);

	FullPath = calloc(1024,sizeof(char));
	GetFullPathName(argv[0],1024,FullPath,NULL);
	for(i = 1,k = strlen(FullPath) ; argv[i] ; i++)
	{
		FullPath[k++] = ' ';
		for(j = 0 ; argv[i][j] ; j++)
			FullPath[k++] = argv[i][j];
	}
	IsSuccess = CreateProcess(NULL,FullPath,NULL, NULL, TRUE, 0, NULL, NULL, &si, &pi);
	free(FullPath);
	if(IsSuccess)
	{
		if(s_task_flag & INI_WAITCHI)
			WaitForSingleObject( pi.hProcess, INFINITE );
	}
	if ( !IsSuccess )
		return -1;

	if ( ret_str_parent )
		slen = strlen(ret_str_parent);
	for ( ; *stp ; stp ++ , close_flags ++ ) {
		if ( ret_str_parent )
			s_write(*stp,ret_str_parent,slen);
		if ( *close_flags )
			s_close(*stp);
	}
	s_write(stp[1],&ch,1);
	return IsSuccess;
}
