/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"memory_debug.h"
#include	"acrp.h"


void
xx_copy_mpt_entry_dir(ACRP_DIR * d1,ACRP_DIR * d2,
char * __file,int __line)
{
	*d1 = *d2;
	if ( d2->hops == -1 )
		return;
	if ( d2->map )
		d1->map = xx_ll_copy_str(d2->map,__file,__line);
	else er_panic("copy_mpt_entry_dir(1)");
	if ( d2->crd )
		d1->crd = xx_ll_copy_str(d2->crd,__file,__line);
}

void
xx_copy_mpt_entry(ACRP_ENTRY * e1,ACRP_ENTRY * e2,
char * __file,int __line)
{
int i;
	*e1 = *e2;
	if ( e2->pri )
		e1->pri = xx_ll_copy_str(e2->pri,__file,__line);
	else	e1->pri = 0;
	for ( i = 0 ; i < ACRP_DIR_NOS ; i ++ )
		xx_copy_mpt_entry_dir(&e1->dir[i],&e2->dir[i],
				      __file,__line);
}

MAP_PATH_TABLE *
xx_copy_mpt(MAP_PATH_TABLE * m,char * __file,int __line)
{
MAP_PATH_TABLE * ret;
int i;

	ret = xx_d_alloc(sizeof(*ret),__file,__line);
	ret->level = m->level;
	ret->id = m->id;
	for ( i = 0 ; i < ACRP_SUBID_NOS ; i ++ )
		xx_copy_mpt_entry(&ret->ent[i],&m->ent[i],__file,__line);
	return ret;
}

