/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"task.h"

extern SEM style_lock,dm_lock,radar_lock;

void
gc_view_lock()
{
	gc_queue_lock_high();
	if ( radar_lock )
		lock_task(radar_lock);
retry:
	gc_gv_resource_onlock();
	if ( dm_lock )
		lock_task(dm_lock);
	if ( gc_gv_resource_clock() < 0 ) {
		if ( dm_lock )
			unlock_task(dm_lock,"gc_view_lock");
		goto retry;
	}
	gc_indicate_lock();
	if ( style_lock )
		lock_task(style_lock);
	gc_xl_lock();
}

void
gc_view_unlock()
{
	gc_xl_unlock();
	gc_indicate_unlock();
	if  ( style_lock )
		unlock_task(style_lock,"gc_unlock style");
	if ( dm_lock )
		unlock_task(dm_lock,"gc_unlock dm");
	gc_gv_resource_unlock();
	if ( radar_lock )
		unlock_task(radar_lock,"gc_view_unlock");
}


void
gc_view()
{
	gc_lib();
	gc_setup();
	gc_gv_resource();
	gc_indicate();
/*
	gc_htmldb();
*/
	gc_dm();
	gc_style();
	gc_radar();
}

