/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef ___CACHE_H___
#define ___CACHE_H___

#include	"pdb.h"
#include	"long_char.h"

typedef struct rcache_blk {
	struct rcache_blk *	next;
	L_CHAR *		path;
	int			lock;
	int			tid;
	int			err;
#define RE_IDLE		0
#define RE_RUN		1
#define RE_STOP		(-1)
#define RE_DESTROY	(-2)
	char *			ent_file;
	int			ent_line;
	char *			ext_file;
	int			ext_line;
} RCACHE_BLK;

#define RCF_ROUTING_MASK	0x00000003
#define RCF_RESOURCE_MASK	0x0000000c

#define RCF_ROUTING		0x00000001
#define RCF_ROUTING_READ	0x00000002
#define RCF_RESOURCE		0x00000004
#define RCF_RESOURCE_READ	0x00000008

#define RCF_ALL			0x0000000f

void rcache_invoke();
void
set_rcache_dir_path(L_CHAR * main_path,L_CHAR * rcache_path);
int new_rcache_blk(RCACHE_BLK * b,char * name);
L_CHAR * get_rcache_file_name(char * name);
int x_local_lock_rcache(RCACHE_BLK *,char * file,int line);
int x_rlock_rcache(RCACHE_BLK *,char * file,int line);
int x_wlock_rcache(RCACHE_BLK *,char * file,int line);
int x_unlock_rcache(RCACHE_BLK *,char * file,int line);
int x_rlock_rcache_path(L_CHAR *,char * file,int line);
int x_wlock_rcache_path(L_CHAR *,char * file,int line);
int unlock_rcache_path(L_CHAR *);
void enable_rcache(int flags);
void purge_rcache(L_CHAR * url);
void enable_rcache();
void disable_rcache();
int get_rcache_flags();


void flush_rt_cache();

#define local_lock_rcache(b) x_local_lock_rcache((b),__FILE__,__LINE__)
#define rlock_rcache(b)	x_rlock_rcache((b),__FILE__,__LINE__)
#define	wlock_rcache(b)	x_wlock_rcache((b),__FILE__,__LINE__)
#define unlock_rcache(b)	x_unlock_rcache((b),__FILE__,__LINE__)
#define rlock_rcache_path(p)	x_rlock_rcache_path((p),__FILE__,__LINE__)
#define wlock_rcache_path(p)	x_wlock_rcache_path((p),__FILE__,__LINE__)

#endif






