/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"xl.h"

char ** argv;
int argc,v_offset;
XL_SEXP * xl_Arg();

void
init_sh_arg(int _argc,char ** _argv)
{
	argc = _argc;
	argv = _argv;
	for ( v_offset = 1 ; v_offset < argc ; v_offset ++ )
		if ( strcmp(argv[v_offset],"/") == 0 )
			break;
}


void
init_Arg(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"Arg"),
		get_func_prim(xl_Arg,FO_APPLICATIVE,0,2,2));
}

XL_SEXP *
xl_Arg(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * arg;
int _arg;
	arg = get_el(s,1);
	switch ( get_type(arg) ) {
	case XLT_ERROR:
		return arg;
	case XLT_INTEGER:
		_arg = arg->integer.data;
		break;
	case XLT_FLOAT:
		_arg = arg->floating.data;
		break;
	default:
		goto type_missmatch;
	}
	_arg += v_offset;
	if ( argc == 0 )
		goto internal_error;
	if ( argc <= _arg || _arg < 0 )
		return get_error(
			s->h.file,
			s->h.line,
			XLE_SEMANTICS_INV_PARAM_LENGTH,
			l_string(std_cm,"Arg"),
			n_get_string("shell argments length over"));
	return get_string(l_string(std_cm,argv[_arg]));
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"Arg"),
		0);
internal_error:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SYSTEM_INTERNAL,
		l_string(std_cm,"Arg"),
		n_get_string("shell argments initializing is required"));
}


