/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"memory_debug.h"
#include	"xlerror.h"
#include	"xl.h"
#include	"utils.h"

XL_SEXP * xl_OpenSession();

void
init_OpenSession(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"OpenSession"),
		get_func_prim(xl_OpenSession,FO_APPLICATIVE,0,1,1));
}

XL_SEXP *
xl_OpenSession(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,
	       XL_SYM_FIELD * sf)
{
int ret;
L_CHAR * type;
int tp;
	type = get_sf_attribute(sf,l_string(std_cm,"type"));
	if ( type == 0 )
		tp = SEST_DIRECT;
	else if ( l_strcmp(type,l_string(std_cm,"direct")) == 0 )
		tp = SEST_DIRECT;
	else	tp = SEST_OPTIMIZE;
	ret = open_session(tp);
	return get_integer(ret,0);
}


