/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/




#include	"xlerror.h"
#include	"xl.h"


XL_SEXP * xl_Sequence();

void
init_Sequence(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"Sequence"),
		get_func_prim(xl_Sequence,FO_NORMAL,0,2,-1));
}


XL_SEXP *
xl_Sequence(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
XL_SEXP * s_env;
XL_SEXP * r, * ret;
XLISP_ENV * ee;
L_CHAR * di;
	s_env = eval(env,get_el(s,1));
	switch ( get_type(s_env) ) {
	case XLT_ERROR:
		return s_env;
	case XLT_NULL:
		ee = env;
		break;
	case XLT_ENV:
		ee = s_env->env.data;
		break;
	default:
		goto type_missmatch;
	}
	ret = 0;

	for ( r = cdr(cdr(s)) ; get_type(r) ; r = cdr(r) ) {
		ret = eval(ee,car(r));
		if ( get_type(ret) == XLT_ERROR )
			return ret;
	}
	return ret;
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"Sequence"),
		n_get_string("type missmatch"));
}

