/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"xl.h"
#include	"xllock.h"

XL_SEXP * xl_Lock();


void
init_Lock(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"Lock"),
		get_func_prim(xl_Lock,FO_APPLICATIVE,0,2,2));
}

XL_SEXP *
xl_Lock(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a_env,XL_SYM_FIELD * sf)
{
XL_SEXP * name;
XL_SEXP * ret;
int type;
	name = get_el(s,1);
	if ( get_type(name) != XLT_STRING )
		goto type_missmatch;
	type = LT_READ;
	for ( ; sf ; sf = sf->next ) {
		if ( l_strcmp(sf->name,l_string(std_cm,"type")) == 0 ) {
			if ( l_strcmp(sf->data,l_string(std_cm,"read")) == 0 )
				type = LT_READ;
			else if ( l_strcmp(sf->data,l_string(std_cm,"write"))
					== 0 )
				type = LT_WRITE;
		}
	}
	return xl_lock(name->string.data,type,s);
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"Lock"),
		0);
}


