#include "gmet/gmet.h"

namespace MetaTemplate {

	int MtData::get_type()  { return org->type; }

	MtData::~MtData() {
		switch (get_type()) {
		case mtTypeBlock:
		{
			/* clean up children list */
			List::iterator it = data.list->begin();
			for (; it != data.list->end(); it++) {
				delete *it;
				*it = 0;
			}
			data.list->clear();
			delete data.list;
			data.list = 0;
			
			break;
		}
		case mtTypeStr:
		{
			delete data.str;
			data.str = 0;
		}
		default:
			break;
		}
	}

	MtData* MtData::get_child(std::string &name) {
		if (org->type != mtTypeBlock)
			return NULL;
		List::iterator l = data.list->begin();
		for (; l != data.list->end(); l++) {
			if (name == (*l)->org->name)
				return *l;
		}
		return NULL;
	}

	MtData* MtData::search(MT_RefPath &path) {
		if (org->type != mtTypeBlock)
			return NULL;

		MtData *md = this;
		MT_RefPath::MT_PATHS::iterator p = path.path.begin();
		for (; p != path.path.end(); p++) {
			md = md->get_child(*p);
			if (!md)
				break;
		}

		if (md && md->org->type != mtTypeBlock)
			return md;
		if (parent)
			return parent->search(path);
		return NULL;
	}

	std::string MtData::get_abs_path() {
		if (!parent)
			return "/" + org->name;
		return parent->get_abs_path() + "/" + org->name;
	}

	int MtData::get_level() {
		if (!parent)
			return 0;
		return parent->get_level() + 1;
	}
	
	int MtData::print(FILE *out) {
		int level = get_level();
		std::string indent;
		indent.insert(indent.begin(), level*2, ' ');

		fprintf(out, "%s", indent.c_str());
		switch (org->type) {
		case mtTypeBlock:
			{
				std::string absPath = get_abs_path();
				fprintf(out, "%s\n", absPath.c_str());
				List::iterator it = data.list->begin();
				for (; it != data.list->end(); it++) {
					if ((*it)->print(out))
						return 1;
				}
				return 0;
			}
		case mtTypeInt:
		case mtTypeFunc:
			fprintf(out, "(%s, 0x%X)\n", org->name.c_str(), data.num);
			return 0;
		case mtTypeStr:
			fprintf(out, "(%s, \"%s\")\n", org->name.c_str(), data.str->c_str());
			return 0;
		default: break;
		}

		return 1;
	}

	MT_RefPath::MT_RefPath(const char *names) {
		if (names) {
			/* Parse names */
			std::string str(names);
			std::string::size_type start = 0;
			std::string::size_type end;

			while (std::string::npos != (end = str.find("->", start))) {
				path.push_back (str.substr (start, end));
				start += end + 2;
			}
			if (path.empty())
				path.push_back (std::string(names));
		}
	}
	
	int MT_RefUnit::get(MtData *parent_) {
		if (path.path.empty())
			return value;
		fprintf(stderr, "Debug: target \"%s\"\n", path.path[0].c_str());
		if (!parent_)
			return -1;
		MtData *tmp = parent_->search(path);
		if (tmp && tmp->get_type() == mtTypeInt) {
			return tmp->data.num;
		}
		if (tmp)
			fprintf(stderr, "target type is \"%d\"\n", tmp->get_type());
			
		return -1;
	}

	MtData* MT_Func_align::scan(MtData *parent_, MT_BitStreamer &bs) {
		MtData *ret = new MtData(this, parent_);
		if (ret)
			ret->data.num = bs.align(arg1);
		return ret;
	}

	MtData* MT_Func_reserve::scan(MtData *parent_, MT_BitStreamer &bs) {
		MtData *ret = new MtData(this, parent_);
		if (ret)
			ret->data.num = bs.reserve(arg1);
		return ret;
	}

	MT_Block::~MT_Block() {
		MT_LIST::iterator it = list.begin();
		for (; it != list.end(); it++) {
			delete *it;
			*it = 0;
		}
	}

	MT_Root::~MT_Root() {
		delete data;
		data = 0;
	}

	MtData* MT_Block::scan(MtData *parent_, MT_BitStreamer &bs) {
		data = new MtData(this, parent_);
		if (!data)
			return NULL;
		
		data->data.list = new std::vector<MtData*>;
		MT_LIST::iterator it = list.begin();
		for (; it != list.end(); it++) {
			int cnt = (*it)->get_count(data);
			if (cnt < 0) {
				fprintf(stderr, "illegal count of %s\n", (*it)->name.c_str());
				return NULL;
			}
			while (cnt > 0 && cnt--) {
				MtData *tmp = (*it)->scan(data, bs);
				if (!tmp) {
					fprintf(stderr, "illegal return from %s\n", (*it)->name.c_str());
					return NULL;
				}
				data->data.list->push_back(tmp);
			}
		}
		return data;
	}

	int MT_Line_Int::pop(MtData *parent_, MT_BitStreamer &bs)  {
		return bs.pop_int(get_size(parent_));
	}

	MtData* MT_Line_Int::scan(MtData *parent_, MT_BitStreamer &bs) {
		MtData *ret  = new MtData(this, parent_);
		if (ret)
			ret->data.num = pop(parent_, bs);
		return ret;
	}

	std::string MT_Line_Str::pop(MtData *parent_, MT_BitStreamer &bs) {
		return bs.pop_str(get_size(parent_));
	}

	MtData* MT_Line_Str::scan(MtData *parent_, MT_BitStreamer &bs)  {
		MtData *ret = new MtData(this, parent_);
		if (ret)
			ret->data.str = new std::string(pop(parent_, bs));
		return ret;
	}

}
