#include <stdio.h>
#include "gmet/gmet.h"

#define PRINTDBG(x) \
do { \
  if (gmetDebug) { \
    char *tmp__ = x; \
    fprintf (stderr, "gmetprint: %s\n", tmp__); \
  } \
} while (0)

int
printData( GmetData * data, int nest )
{
  if ( !data )
    return -1;

  char *indent = malloc( 2 * nest + 1 );
  if ( !indent )
    return -1;

  int i = 0;
  for ( ; i < nest; i++ )
    sprintf( indent + 2 * i, "  " );
  indent[2 * nest] = 0;

  switch ( gmetDataType( data ) )
  {
  case gmetTypeBlock:
    {
      printf( "%s%s =>\n", indent, data->org->name );
      int i, max = gmetVectorSize( data->data.list );
      for ( i = 0; i < max; i++ )
        printData( gmetVectorGet( data->data.list, i ), nest + 1 );
    }
    break;
  case gmetTypeInt:
    printf( "%s%s: %d\n", indent, data->org->name, data->data.num );
    break;
  case gmetTypeStr:
    printf( "%s%s: \"%s\"\n", indent, data->org->name, data->data.str );
    break;
  default:
    printf( "type error\n" );
    break;
  }
  return 0;
}

int
main( int argc, char **argv )
{
  char c;

  gmetDebug = 0;
  PRINTDBG( "start" );

  GmetRoot *root = gmetNewRoot(  );
  if ( !root )
  {
    PRINTDBG( "create root ...failure" );
    return -1;
  }
  PRINTDBG( "create root ...success" );

  FILE *fp;
  if ( argc == 1 )
    fp = stdin;
  else
    fp = fopen( argv[1], "rb" );

  GmetStream *stream = gmetNewStream( fp );
  if ( !stream )
  {
    PRINTDBG( "init stream ...failure" );
    return -1;
  }
  PRINTDBG( "init stream ...success" );

  GmetData *data = gmetNewData( NULL, ( GmetStatement * ) root, stream );
  if ( !data )
  {
    PRINTDBG( "parse data ...failure" );
    return -1;
  }
  PRINTDBG( "parse data ...success" );

  if ( printData( data, 0 ) )
  {
    PRINTDBG( "print ...failure" );
    return -1;
  }

  gmetDeleteData( data );
  PRINTDBG( "delete data ...success" );

  gmetDeleteStream( stream );
  PRINTDBG( "delete stream ...success" );

  gmetDeleteRoot( root );
  PRINTDBG( "delete root ...success" );

  return 0;
}
