/* $Id: background.h,v 1.2 2002/07/17 13:24:19 iiojun Exp $ */

/* Face Pointer Library
 * Copyright (C) 1999-2002 Kazuo HIYANE, Jun IIO, and Tomoyuki YATABE
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __BACKGROUND_H__
#define __BACKGROUND_H__

#include <malib/malib.h>

BEGIN_C_DECLS

typedef struct _Background Background;
typedef struct _BackgroundClass BackgroundClass;

#include <malib/filter.h>

struct _Background
{
  MalibFilter		super;

  /* pointer to the background image data */
  unsigned char*	bg_image;
};

struct _BackgroundClass
{
  MalibFilterClass	super;
};

Background*  background_new (void);
Background*  background_new_with_buf (MalibBuffer* buf);  
Background*  background_new_with_image_and_buf (char* bg_image, MalibBuffer* buf);  
void	     background_set_buffer (Background* filter, MalibBuffer* buf);
void	     background_set_bg_image (Background* filter, char* bg_image);

END_C_DECLS

#endif /* __BACKGROUND_H__ */
