#ifndef __RANGE2D_H__
#define __RANGE2D_H__

#ifdef __cplusplus__
extern "C" {
#endif

#include <stdlib.h>
#include <gnome.h>

#define GTK_TYPE_RANGE2D (gtk_range2d_get_type())
#define GTK_RANGE2D(obj) (GTK_CHECK_CAST ((obj), \
                      GTK_TYPE_RANGE2D, GtkRange2d))
#define GTK_RANGE2D_CLASS(klass) (GTK_CHECK_CLASS_CAST ((klass), \
                      GTK_TYPE_RANGE2D, GtkRange2dClass))
#define GTK_IS_RANGE2D(obj) (GTK_CHECK_TYPE ((obj), GTK_TYPE_RANGE2D))
#define GTK_IS_RANGE2D_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), \
                      GTK_TYPE_RANGE2D))

typedef struct _GtkRange2dClass GtkRange2dClass;
typedef struct _GtkRange2d GtkRange2d;

struct _GtkRange2d
{
  GtkWindow window;
  
  /* alpha, beta, r_alpha, r_beta */
  double parameter[4];
  /* previously dragged point */
  double x0, y0;

  /* This flag shows whether we are in move action state, or not. */
  gboolean move_dragged;
  /* This flag shows whether we are in resize action state, or not. */
  gboolean resize_dragged;

  /* GtkWidget */
  GtkWidget* hbox;
  GtkWidget* frame;
  GtkWidget* canvas, * table1, * table2, * hrule, * vrule;
  GtkWidget* entry_a;
  GtkWidget* entry_b;
  GtkWidget* entry_ra;
  GtkWidget* entry_rb;
  GtkWidget* label_a;
  GtkWidget* label_b;
  GtkWidget* label_ra;
  GtkWidget* label_rb;
  GtkWidget* button_save;
  GtkWidget* button_load;

  /* canvas */
  GnomeCanvasGroup* root;
  GnomeCanvasItem* rect;
  GnomeCanvasItem* ellipse;
  GnomeCanvasItem* pick11;
};

struct _GtkRange2dClass
{
  GtkWindowClass parent_class;
};

GtkType gtk_range2d_get_type(void);
GtkWidget* gtk_range2d_new(void);

void gtk_range2d_set_value(GtkRange2d* range2d,
			   double a, double b, double ra, double rb);
void gtk_range2d_get_value(GtkRange2d* range2d,
			   double* a, double* b, double* ra, double* rb);

#ifdef __cplusplus__
}
#endif

#endif /* __RANGE2D_H__ */
