/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.service.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javassist.CtClass;
import javassist.CtMethod;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.service.InterfaceFab;
import org.apache.hivemind.service.MethodSignature;
import org.apache.hivemind.service.impl.AbstractFab;
import org.apache.hivemind.service.impl.CtClassSource;
import org.apache.hivemind.service.impl.ServiceMessages;

public class InterfaceFabImpl
extends AbstractFab
implements InterfaceFab {
    private List _methods = new ArrayList();

    public InterfaceFabImpl(CtClassSource source, CtClass ctClass) {
        super(source, ctClass);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("InterfaceFabImpl[\npublic interface ");
        CtClass ctClass = this.getCtClass();
        buffer.append(ctClass.getName());
        try {
            CtClass[] interfaces = ctClass.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                buffer.append(i == 0 ? " extends " : ", ");
                buffer.append(interfaces[i].getName());
            }
        }
        catch (Exception ex) {
            buffer.append("<Exception: " + ex + ">");
        }
        Iterator i = this._methods.iterator();
        while (i.hasNext()) {
            MethodSignature sig = (MethodSignature)i.next();
            buffer.append("\n\npublic ");
            buffer.append(sig);
            buffer.append(";");
        }
        buffer.append("\n]");
        return buffer.toString();
    }

    public void addMethod(MethodSignature ms) {
        CtClass ctReturnType = this.convertClass(ms.getReturnType());
        CtClass[] ctParameters = this.convertClasses(ms.getParameterTypes());
        CtClass[] ctExceptions = this.convertClasses(ms.getExceptionTypes());
        CtMethod method = new CtMethod(ctReturnType, ms.getName(), ctParameters, this.getCtClass());
        try {
            method.setModifiers(1025);
            method.setExceptionTypes(ctExceptions);
            this.getCtClass().addMethod(method);
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(ServiceMessages.unableToAddMethod(ms, this.getCtClass(), ex), ex);
        }
        this._methods.add(ms);
    }

    public Class createInterface() {
        return this.createClass();
    }
}

