/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.tcp;

import java.io.IOException;
import java.net.InetAddress;
import org.apache.catalina.cluster.tcp.ClusterData;
import org.apache.catalina.cluster.tcp.DataSender;
import org.apache.catalina.cluster.util.FastQueue;
import org.apache.catalina.cluster.util.IQueue;
import org.apache.catalina.cluster.util.LinkObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FastAsyncSocketSender
extends DataSender {
    private static int threadCounter = 1;
    private static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$cluster$tcp$FastAsyncSocketSender == null ? (class$org$apache$catalina$cluster$tcp$FastAsyncSocketSender = FastAsyncSocketSender.class$("org.apache.catalina.cluster.tcp.FastAsyncSocketSender")) : class$org$apache$catalina$cluster$tcp$FastAsyncSocketSender));
    private static final String info = "FastAsyncSocketSender/3.0";
    private FastQueue queue = new FastQueue();
    private FastQueueThread queueThread = null;
    private long inQueueCounter = 0L;
    private long outQueueCounter = 0L;
    private int threadPriority = 5;
    static /* synthetic */ Class class$org$apache$catalina$cluster$tcp$FastAsyncSocketSender;

    public FastAsyncSocketSender(String domain, InetAddress host, int port) {
        super(domain, host, port);
        this.checkThread();
    }

    public String getInfo() {
        return info;
    }

    public long getQueueAddWaitTimeout() {
        return this.queue.getAddWaitTimeout();
    }

    public void setQueueAddWaitTimeout(long timeout) {
        this.queue.setAddWaitTimeout(timeout);
    }

    public long getQueueRemoveWaitTimeout() {
        return this.queue.getRemoveWaitTimeout();
    }

    public void setRemoveWaitTimeout(long timeout) {
        this.queue.setRemoveWaitTimeout(timeout);
    }

    public boolean isQueueCheckLock() {
        return this.queue.isCheckLock();
    }

    public void setQueueCheckLock(boolean checkLock) {
        this.queue.setCheckLock(checkLock);
    }

    public boolean isQueueDoStats() {
        return this.queue.isDoStats();
    }

    public void setQueueDoStats(boolean doStats) {
        this.queue.setDoStats(doStats);
    }

    public boolean isQueueTimeWait() {
        return this.queue.isTimeWait();
    }

    public void setQueueTimeWait(boolean timeWait) {
        this.queue.setTimeWait(timeWait);
    }

    public int getMaxQueueLength() {
        return this.queue.getMaxQueueLength();
    }

    public void setMaxQueueLength(int length) {
        this.queue.setMaxQueueLength(length);
    }

    public long getQueueAddWaitTime() {
        return this.queue.getAddWait();
    }

    public long getQueueRemoveWaitTime() {
        return this.queue.getRemoveWait();
    }

    public long getInQueueCounter() {
        return this.inQueueCounter;
    }

    public long getOutQueueCounter() {
        return this.outQueueCounter;
    }

    public int getQueueSize() {
        return this.queue.getSize();
    }

    public void setThreadPriority(int threadPriority) {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("FastAsyncSocketSender.setThreadPriority", (Object)this.getAddress().getHostAddress(), (Object)new Integer(this.getPort()), (Object)new Integer(threadPriority)));
        }
        if (threadPriority < 1) {
            throw new IllegalArgumentException(sm.getString("FastAsyncSocketSender.min.exception", (Object)this.getAddress().getHostAddress(), (Object)new Integer(this.getPort()), (Object)new Integer(threadPriority)));
        }
        if (threadPriority > 10) {
            throw new IllegalArgumentException(sm.getString("FastAsyncSocketSender.max.exception", (Object)this.getAddress().getHostAddress(), (Object)new Integer(this.getPort()), (Object)new Integer(threadPriority)));
        }
        this.threadPriority = threadPriority;
        if (this.queueThread != null) {
            this.queueThread.setPriority(threadPriority);
        }
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public long getQueuedNrOfBytes() {
        if (this.queueThread != null) {
            return this.queueThread.getQueuedNrOfBytes();
        }
        return 0L;
    }

    public void connect() throws IOException {
        super.connect();
        this.checkThread();
        if (!this.queue.isEnabled()) {
            this.queue.start();
        }
    }

    public void disconnect() {
        this.stopThread();
        this.queue.stop();
        this.queue.start();
        super.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(ClusterData data) throws IOException {
        this.queue.add(data.getUniqueId(), data);
        FastAsyncSocketSender fastAsyncSocketSender = this;
        synchronized (fastAsyncSocketSender) {
            ++this.inQueueCounter;
            if (this.queueThread != null) {
                this.queueThread.incQueuedNrOfBytes(data.getMessage().length);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("AsyncSocketSender.queue.message", (Object)this.getAddress().getHostAddress(), (Object)new Integer(this.getPort()), (Object)data.getUniqueId(), (Object)new Long(data.getMessage().length)));
        }
    }

    public synchronized void resetStatistics() {
        super.resetStatistics();
        this.inQueueCounter = this.queue.getSize();
        this.outQueueCounter = 0L;
        this.queue.resetStatistics();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("FastAsyncSocketSender[");
        buf.append(this.getAddress().getHostAddress()).append(":").append(this.getPort()).append("]");
        return buf.toString();
    }

    protected void checkThread() {
        if (this.queueThread == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)sm.getString("AsyncSocketSender.create.thread", (Object)this.getAddress(), (Object)new Integer(this.getPort())));
            }
            this.queueThread = new FastQueueThread(this, this.queue);
            this.queueThread.setDaemon(true);
            this.queueThread.setPriority(this.getThreadPriority());
            this.queueThread.start();
        }
    }

    protected void stopThread() {
        if (this.queueThread != null) {
            this.queueThread.stopRunning();
            this.queueThread = null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class FastQueueThread
    extends Thread {
        private IQueue queue = null;
        private FastAsyncSocketSender sender = null;
        private boolean keepRunning = true;
        private long queuedNrOfBytes = 0L;

        private FastQueueThread(FastAsyncSocketSender sender, IQueue queue) {
            this.setName("Cluster-FastAsyncSocketSender-" + threadCounter++);
            this.queue = queue;
            this.sender = sender;
        }

        public long getQueuedNrOfBytes() {
            return this.queuedNrOfBytes;
        }

        protected synchronized void setQueuedNrOfBytes(long queuedNrOfBytes) {
            this.queuedNrOfBytes = queuedNrOfBytes;
        }

        protected synchronized void incQueuedNrOfBytes(long size) {
            this.queuedNrOfBytes += size;
        }

        protected synchronized void decQueuedNrOfBytes(long size) {
            this.queuedNrOfBytes -= size;
        }

        public void stopRunning() {
            this.keepRunning = false;
        }

        public void run() {
            while (this.keepRunning) {
                LinkObject entry = this.getQueuedMessage();
                if (entry != null) {
                    this.pushQueuedMessages(entry);
                    continue;
                }
                if (!this.keepRunning) continue;
                log.warn((Object)DataSender.sm.getString("AsyncSocketSender.queue.empty", (Object)this.sender.getAddress(), (Object)new Integer(this.sender.getPort())));
            }
        }

        protected LinkObject getQueuedMessage() {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Queuesize before=" + ((FastQueue)this.queue).getSize()));
            }
            LinkObject entry = this.queue.remove();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Queuesize after=" + ((FastQueue)this.queue).getSize()));
            }
            return entry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void pushQueuedMessages(LinkObject entry) {
            do {
                int messagesize = 0;
                try {
                    ClusterData data = (ClusterData)entry.data();
                    messagesize = data.getMessage().length;
                    this.sender.pushMessage(data);
                }
                catch (Exception x) {
                    log.warn((Object)DataSender.sm.getString("AsyncSocketSender.send.error", entry.getKey()), (Throwable)x);
                }
                finally {
                    FastAsyncSocketSender.this.outQueueCounter++;
                    this.decQueuedNrOfBytes(messagesize);
                }
            } while ((entry = entry.next()) != null);
        }
    }
}

