/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.util;

import org.apache.catalina.cluster.util.IQueue;
import org.apache.catalina.cluster.util.LinkObject;
import org.apache.catalina.cluster.util.SingleRemoveSynchronizedAddLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FastQueue
implements IQueue {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$cluster$util$FastQueue == null ? (class$org$apache$catalina$cluster$util$FastQueue = FastQueue.class$("org.apache.catalina.cluster.util.FastQueue")) : class$org$apache$catalina$cluster$util$FastQueue));
    private SingleRemoveSynchronizedAddLock lock = new SingleRemoveSynchronizedAddLock();
    private LinkObject first = null;
    private LinkObject last = null;
    private int size = 0;
    private boolean checkLock = false;
    private boolean timeWait = false;
    private boolean doStats = false;
    private boolean inAdd = false;
    private boolean inRemove = false;
    private boolean inMutex = false;
    private int maxQueueLength = 0;
    private long addWaitTimeout = 10000L;
    private long removeWaitTimeout = 30000L;
    private boolean enabled = true;
    private long addCounter = 0L;
    private long addErrorCounter = 0L;
    private long removeCounter = 0L;
    private long removeErrorCounter = 0L;
    private long addWait = 0L;
    private long removeWait = 0L;
    private int maxSize = 0;
    private long avgSize = 0L;
    private int maxSizeSample = 0;
    private long avgSizeSample = 0L;
    private int sampleInterval = 100;
    static /* synthetic */ Class class$org$apache$catalina$cluster$util$FastQueue;

    public FastQueue() {
        this.lock.setAddWaitTimeout(this.addWaitTimeout);
        this.lock.setRemoveWaitTimeout(this.removeWaitTimeout);
    }

    public long getAddWaitTimeout() {
        this.addWaitTimeout = this.lock.getAddWaitTimeout();
        return this.addWaitTimeout;
    }

    public void setAddWaitTimeout(long timeout) {
        this.addWaitTimeout = timeout;
        this.lock.setAddWaitTimeout(this.addWaitTimeout);
    }

    public long getRemoveWaitTimeout() {
        this.removeWaitTimeout = this.lock.getRemoveWaitTimeout();
        return this.removeWaitTimeout;
    }

    public void setRemoveWaitTimeout(long timeout) {
        this.removeWaitTimeout = timeout;
        this.lock.setRemoveWaitTimeout(this.removeWaitTimeout);
    }

    public int getMaxQueueLength() {
        return this.maxQueueLength;
    }

    public void setMaxQueueLength(int length) {
        this.maxQueueLength = length;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
        if (!this.enabled) {
            this.lock.abortRemove();
        }
    }

    public boolean isCheckLock() {
        return this.checkLock;
    }

    public void setCheckLock(boolean checkLock) {
        this.checkLock = checkLock;
    }

    public boolean isDoStats() {
        return this.doStats;
    }

    public void setDoStats(boolean doStats) {
        this.doStats = doStats;
    }

    public boolean isTimeWait() {
        return this.timeWait;
    }

    public void setTimeWait(boolean timeWait) {
        this.timeWait = timeWait;
    }

    public int getSampleInterval() {
        return this.sampleInterval;
    }

    public void setSampleInterval(int interval) {
        this.sampleInterval = interval;
    }

    public long getAddCounter() {
        return this.addCounter;
    }

    public void setAddCounter(long counter) {
        this.addCounter = counter;
    }

    public long getAddErrorCounter() {
        return this.addErrorCounter;
    }

    public void setAddErrorCounter(long counter) {
        this.addErrorCounter = counter;
    }

    public long getRemoveCounter() {
        return this.removeCounter;
    }

    public void setRemoveCounter(long counter) {
        this.removeCounter = counter;
    }

    public long getRemoveErrorCounter() {
        return this.removeErrorCounter;
    }

    public void setRemoveErrorCounter(long counter) {
        this.removeErrorCounter = counter;
    }

    public long getAddWait() {
        return this.addWait;
    }

    public void setAddWait(long wait) {
        this.addWait = wait;
    }

    public long getRemoveWait() {
        return this.removeWait;
    }

    public void setRemoveWait(long wait) {
        this.removeWait = wait;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int size) {
        this.maxSize = size;
    }

    public long getAvgSize() {
        if (this.addCounter > 0L) {
            return this.avgSize / this.addCounter;
        }
        return 0L;
    }

    public void resetStatistics() {
        this.addCounter = 0L;
        this.addErrorCounter = 0L;
        this.removeCounter = 0L;
        this.removeErrorCounter = 0L;
        this.avgSize = 0L;
        this.maxSize = 0;
        this.addWait = 0L;
        this.removeWait = 0L;
    }

    public void unlockAdd() {
        this.lock.unlockAdd(this.size > 0);
    }

    public void unlockRemove() {
        this.lock.unlockRemove();
    }

    public void start() {
        this.setEnabled(true);
    }

    public void stop() {
        this.setEnabled(false);
    }

    public long getSample() {
        return this.addCounter % (long)this.sampleInterval;
    }

    public int getMaxSizeSample() {
        return this.maxSizeSample;
    }

    public void setMaxSizeSample(int size) {
        this.maxSizeSample = size;
    }

    public long getAvgSizeSample() {
        long sample = this.addCounter % (long)this.sampleInterval;
        if (sample > 0L) {
            return this.avgSizeSample / sample;
        }
        if (this.addCounter > 0L) {
            return this.avgSizeSample / (long)this.sampleInterval;
        }
        return 0L;
    }

    public int getSize() {
        int sz = this.size;
        return sz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(String key, Object data) {
        boolean ok = true;
        long time = 0L;
        if (!this.enabled) {
            if (log.isInfoEnabled()) {
                log.info((Object)"FastQueue.add: queue disabled, add aborted");
            }
            return false;
        }
        if (this.timeWait) {
            time = System.currentTimeMillis();
        }
        this.lock.lockAdd();
        try {
            if (this.timeWait) {
                this.addWait += System.currentTimeMillis() - time;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("FastQueue.add: starting with size " + this.size));
            }
            if (this.checkLock) {
                if (this.inAdd) {
                    log.warn((Object)"FastQueue.add: Detected other add");
                }
                this.inAdd = true;
                if (this.inMutex) {
                    log.warn((Object)"FastQueue.add: Detected other mutex in add");
                }
                this.inMutex = true;
            }
            if (this.maxQueueLength > 0 && this.size >= this.maxQueueLength) {
                ok = false;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("FastQueue.add: Could not add, since queue is full (" + this.size + ">=" + this.maxQueueLength + ")"));
                }
            } else {
                LinkObject element = new LinkObject(key, data);
                if (this.size == 0) {
                    this.first = this.last = element;
                    this.size = 1;
                } else if (this.last == null) {
                    ok = false;
                    log.error((Object)("FastQueue.add: Could not add, since last is null although size is " + this.size + " (>0)"));
                } else {
                    this.last.append(element);
                    this.last = element;
                    ++this.size;
                }
            }
            if (this.doStats) {
                if (ok) {
                    if (this.addCounter % (long)this.sampleInterval == 0L) {
                        this.maxSizeSample = 0;
                        this.avgSizeSample = 0L;
                    }
                    ++this.addCounter;
                    if (this.size > this.maxSize) {
                        this.maxSize = this.size;
                    }
                    if (this.size > this.maxSizeSample) {
                        this.maxSizeSample = this.size;
                    }
                    this.avgSize += (long)this.size;
                    this.avgSizeSample += (long)this.size;
                } else {
                    ++this.addErrorCounter;
                }
            }
            if (this.first == null) {
                log.error((Object)("FastQueue.add: first is null, size is " + this.size + " at end of add"));
            }
            if (this.last == null) {
                log.error((Object)("FastQueue.add: last is null, size is " + this.size + " at end of add"));
            }
            if (this.checkLock) {
                if (!this.inMutex) {
                    log.warn((Object)"FastQueue.add: Cancelled by other mutex in add");
                }
                this.inMutex = false;
                if (!this.inAdd) {
                    log.warn((Object)"FastQueue.add: Cancelled by other add");
                }
                this.inAdd = false;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("FastQueue.add: add ending with size " + this.size));
            }
            if (this.timeWait) {
                time = System.currentTimeMillis();
            }
        }
        finally {
            this.lock.unlockAdd(true);
        }
        if (this.timeWait) {
            this.addWait += System.currentTimeMillis() - time;
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkObject remove() {
        LinkObject element;
        long time = 0L;
        if (!this.enabled) {
            if (log.isInfoEnabled()) {
                log.info((Object)"FastQueue.remove: queue disabled, remove aborted");
            }
            return null;
        }
        if (this.timeWait) {
            time = System.currentTimeMillis();
        }
        boolean gotLock = this.lock.lockRemove();
        try {
            if (!gotLock) {
                if (this.enabled) {
                    if (this.timeWait) {
                        this.removeWait += System.currentTimeMillis() - time;
                    }
                    if (this.doStats) {
                        ++this.removeErrorCounter;
                    }
                    if (log.isInfoEnabled()) {
                        log.info((Object)"FastQueue.remove: Remove aborted although queue enabled");
                    }
                } else if (log.isInfoEnabled()) {
                    log.info((Object)"FastQueue.remove: queue disabled, remove aborted");
                }
                LinkObject linkObject = null;
                return linkObject;
            }
            if (this.timeWait) {
                this.removeWait += System.currentTimeMillis() - time;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("FastQueue.remove: remove starting with size " + this.size));
            }
            if (this.checkLock) {
                if (this.inRemove) {
                    log.warn((Object)"FastQueue.remove: Detected other remove");
                }
                this.inRemove = true;
                if (this.inMutex) {
                    log.warn((Object)"FastQueue.remove: Detected other mutex in remove");
                }
                this.inMutex = true;
            }
            element = this.first;
            if (this.doStats) {
                if (element != null) {
                    ++this.removeCounter;
                } else {
                    ++this.removeErrorCounter;
                    log.error((Object)("FastQueue.remove: Could not remove, since first is null although size is " + this.size + " (>0)"));
                }
            }
            this.last = null;
            this.first = null;
            this.size = 0;
            if (this.checkLock) {
                if (!this.inMutex) {
                    log.warn((Object)"FastQueue.remove: Cancelled by other mutex in remove");
                }
                this.inMutex = false;
                if (!this.inRemove) {
                    log.warn((Object)"FastQueue.remove: Cancelled by other remove");
                }
                this.inRemove = false;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("FastQueue.remove: remove ending with size " + this.size));
            }
            if (this.timeWait) {
                time = System.currentTimeMillis();
            }
        }
        finally {
            this.lock.unlockRemove();
        }
        if (this.timeWait) {
            this.removeWait += System.currentTimeMillis() - time;
        }
        return element;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

