/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp.datasources;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.sql.ConnectionPoolDataSource;
import org.apache.tomcat.dbcp.collections.LRUMap;
import org.apache.tomcat.dbcp.dbcp.SQLNestedException;
import org.apache.tomcat.dbcp.dbcp.datasources.InstanceKeyDataSource;
import org.apache.tomcat.dbcp.dbcp.datasources.InstanceKeyObjectFactory;
import org.apache.tomcat.dbcp.dbcp.datasources.KeyedCPDSConnectionFactory;
import org.apache.tomcat.dbcp.dbcp.datasources.PooledConnectionAndInfo;
import org.apache.tomcat.dbcp.dbcp.datasources.SharedPoolDataSourceFactory;
import org.apache.tomcat.dbcp.dbcp.datasources.UserPassKey;
import org.apache.tomcat.dbcp.pool.KeyedObjectPool;
import org.apache.tomcat.dbcp.pool.impl.GenericKeyedObjectPool;

public class SharedPoolDataSource
extends InstanceKeyDataSource {
    private static final Map userKeys = new LRUMap(10);
    private int maxActive = 8;
    private int maxIdle = 8;
    private int maxWait = (int)Math.min(Integer.MAX_VALUE, -1L);
    private KeyedObjectPool pool = null;

    public void close() throws Exception {
        this.pool.close();
        InstanceKeyObjectFactory.removeInstance(this.instanceKey);
    }

    public int getMaxActive() {
        return this.maxActive;
    }

    public void setMaxActive(int maxActive) {
        this.assertInitializationAllowed();
        this.maxActive = maxActive;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(int maxIdle) {
        this.assertInitializationAllowed();
        this.maxIdle = maxIdle;
    }

    public int getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(int maxWait) {
        this.assertInitializationAllowed();
        this.maxWait = maxWait;
    }

    public int getNumActive() {
        return this.pool == null ? 0 : this.pool.getNumActive();
    }

    public int getNumIdle() {
        return this.pool == null ? 0 : this.pool.getNumIdle();
    }

    protected synchronized PooledConnectionAndInfo getPooledConnectionAndInfo(String username, String password) throws SQLException {
        if (this.pool == null) {
            try {
                this.registerPool(username, password);
            }
            catch (NamingException e) {
                throw new SQLNestedException("RegisterPool failed", e);
            }
        }
        PooledConnectionAndInfo info = null;
        try {
            info = (PooledConnectionAndInfo)this.pool.borrowObject(this.getUserPassKey(username, password));
        }
        catch (Exception e) {
            throw new SQLNestedException("Could not retrieve connection info from pool", e);
        }
        return info;
    }

    private UserPassKey getUserPassKey(String username, String password) {
        UserPassKey key = (UserPassKey)userKeys.get(username);
        if (key == null) {
            key = new UserPassKey(username, password);
            userKeys.put(username, key);
        }
        return key;
    }

    private void registerPool(String username, String password) throws NamingException, SQLException {
        ConnectionPoolDataSource cpds = this.testCPDS(username, password);
        GenericKeyedObjectPool tmpPool = new GenericKeyedObjectPool(null);
        tmpPool.setMaxActive(this.getMaxActive());
        tmpPool.setMaxIdle(this.getMaxIdle());
        tmpPool.setMaxWait(this.getMaxWait());
        tmpPool.setWhenExhaustedAction(this.whenExhaustedAction(this.maxActive, this.maxWait));
        tmpPool.setTestOnBorrow(this.getTestOnBorrow());
        tmpPool.setTestOnReturn(this.getTestOnReturn());
        tmpPool.setTimeBetweenEvictionRunsMillis(this.getTimeBetweenEvictionRunsMillis());
        tmpPool.setNumTestsPerEvictionRun(this.getNumTestsPerEvictionRun());
        tmpPool.setMinEvictableIdleTimeMillis(this.getMinEvictableIdleTimeMillis());
        tmpPool.setTestWhileIdle(this.getTestWhileIdle());
        this.pool = tmpPool;
        new KeyedCPDSConnectionFactory(cpds, this.pool, this.getValidationQuery());
    }

    protected void setupDefaults(Connection con, String username) throws SQLException {
        con.setAutoCommit(this.isDefaultAutoCommit());
        con.setReadOnly(this.isDefaultReadOnly());
        int defaultTransactionIsolation = this.getDefaultTransactionIsolation();
        if (defaultTransactionIsolation != -1) {
            con.setTransactionIsolation(defaultTransactionIsolation);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            in.defaultReadObject();
            SharedPoolDataSource oldDS = (SharedPoolDataSource)new SharedPoolDataSourceFactory().getObjectInstance((Object)this.getReference(), (Name)null, (Context)null, (Hashtable)null);
            this.pool = oldDS.pool;
        }
        catch (NamingException e) {
            throw new IOException("NamingException: " + e);
        }
    }
}

