/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.asset;

import java.util.Locale;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.Location;
import org.apache.hivemind.Resource;
import org.apache.tapestry.IAsset;
import org.apache.tapestry.asset.AssetFactory;
import org.apache.tapestry.asset.AssetMessages;
import org.apache.tapestry.asset.ContextAsset;
import org.apache.tapestry.l10n.ResourceLocalizer;
import org.apache.tapestry.web.WebContext;
import org.apache.tapestry.web.WebContextResource;

public class ContextAssetFactory
implements AssetFactory {
    private String _contextPath;
    private AssetFactory _classpathAssetFactory;
    private WebContext _webContext;
    private ResourceLocalizer _localizer;

    public void setWebContext(WebContext webContext) {
        this._webContext = webContext;
    }

    public IAsset createAsset(Resource baseResource, String path, Locale locale, Location location) {
        Resource assetResource = baseResource.getRelativeResource(path);
        if (assetResource.getResourceURL() == null && path.startsWith("/")) {
            return this._classpathAssetFactory.createAbsoluteAsset(path, locale, location);
        }
        Resource localized = this._localizer.findLocalization(assetResource, locale);
        if (localized == null) {
            throw new ApplicationRuntimeException(AssetMessages.missingAsset(path, baseResource), location, null);
        }
        return this.createAsset(localized, location);
    }

    public IAsset createAbsoluteAsset(String path, Locale locale, Location location) {
        WebContextResource base = new WebContextResource(this._webContext, path);
        Resource localized = this._localizer.findLocalization((Resource)base, locale);
        if (localized == null) {
            throw new ApplicationRuntimeException(AssetMessages.missingContextResource(path), location, null);
        }
        return this.createAsset(localized, location);
    }

    public IAsset createAsset(Resource resource, Location location) {
        return new ContextAsset(this._contextPath, resource, location);
    }

    public void setContextPath(String contextPath) {
        this._contextPath = contextPath;
    }

    public void setClasspathAssetFactory(AssetFactory classpathAssetFactory) {
        this._classpathAssetFactory = classpathAssetFactory;
    }

    public void setLocalizer(ResourceLocalizer localizer) {
        this._localizer = localizer;
    }
}

