/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.form;

import java.text.MessageFormat;
import java.util.Locale;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.form.ValidationMessages;
import org.apache.tapestry.valid.ValidationStrings;

public class ValidationMessagesImpl
implements ValidationMessages {
    private final IFormComponent _field;
    private final Locale _locale;

    public ValidationMessagesImpl(IFormComponent field, Locale locale) {
        Defense.notNull((Object)field, (String)"field");
        Defense.notNull((Object)locale, (String)"locale");
        this._field = field;
        this._locale = locale;
    }

    public String formatValidationMessage(String messageOverride, String messageKey, Object[] arguments) {
        String message = this.extractLocalizedMessage(messageOverride, messageKey);
        return MessageFormat.format(message, arguments);
    }

    private String extractLocalizedMessage(String messageOverride, String messageKey) {
        if (messageOverride == null) {
            return ValidationStrings.getMessagePattern(messageKey, this._locale);
        }
        if (messageOverride.startsWith("%")) {
            String key = messageOverride.substring(1);
            return this._field.getContainer().getMessages().getMessage(key);
        }
        return messageOverride;
    }

    public Locale getLocale() {
        return this._locale;
    }
}

