/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.form.validator;

import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.TapestryUtils;
import org.apache.tapestry.form.FormComponentContributorContext;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.form.ValidationMessages;
import org.apache.tapestry.form.validator.BaseValidator;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidatorException;

public class MaxLength
extends BaseValidator {
    private int _maxLength;

    public MaxLength() {
    }

    public MaxLength(String initializer) {
        super(initializer);
    }

    public void setMaxLength(int maxLength) {
        this._maxLength = maxLength;
    }

    public void validate(IFormComponent field, ValidationMessages messages, Object object) throws ValidatorException {
        String string = (String)object;
        if (string.length() > this._maxLength) {
            throw new ValidatorException(this.buildMessage(messages, field), ValidationConstraint.MAXIMUM_WIDTH);
        }
    }

    protected String buildMessage(ValidationMessages messages, IFormComponent field) {
        return messages.formatValidationMessage(this.getMessage(), "field-too-long", new Object[]{new Integer(this._maxLength), field.getDisplayName()});
    }

    public void renderContribution(IMarkupWriter writer, IRequestCycle cycle, FormComponentContributorContext context, IFormComponent field) {
        context.includeClasspathScript("/org/apache/tapestry/form/validator/StringValidator.js");
        StringBuffer buffer = new StringBuffer("function(event) { Tapestry.validate_max_length(event, '");
        buffer.append(field.getClientId());
        buffer.append("', ");
        buffer.append(this._maxLength);
        buffer.append(", ");
        buffer.append(TapestryUtils.enquote(this.buildMessage(context, field)));
        buffer.append("); }");
        context.addSubmitHandler(buffer.toString());
    }
}

