/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.html;

import java.util.HashMap;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.tapestry.AbstractComponent;
import org.apache.tapestry.IAsset;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IScript;
import org.apache.tapestry.PageRenderSupport;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.TapestryUtils;
import org.apache.tapestry.components.ILinkComponent;
import org.apache.tapestry.components.LinkEventType;

public abstract class Rollover
extends AbstractComponent {
    protected String getAssetURL(IAsset asset) {
        if (asset == null) {
            return null;
        }
        return asset.buildURL();
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        if (cycle.isRewinding()) {
            return;
        }
        String imageURL = null;
        String mouseOverURL = null;
        String mouseOutURL = null;
        boolean dynamic = false;
        String imageId = null;
        PageRenderSupport pageRenderSupport = TapestryUtils.getPageRenderSupport(cycle, this);
        ILinkComponent serviceLink = (ILinkComponent)cycle.getAttribute("org.apache.tapestry.active-link-component");
        if (serviceLink == null) {
            throw new ApplicationRuntimeException(Tapestry.getMessage("Rollover.must-be-contained-by-link"), (Object)this, null, null);
        }
        boolean linkDisabled = serviceLink.isDisabled();
        if (linkDisabled) {
            imageURL = this.getAssetURL(this.getDisabled());
            if (imageURL == null) {
                imageURL = this.getAssetURL(this.getImage());
            }
        } else {
            imageURL = this.getAssetURL(this.getImage());
            mouseOverURL = this.getAssetURL(this.getMouseOver());
            mouseOutURL = this.getAssetURL(this.getMouseOut());
            boolean bl = dynamic = mouseOverURL != null || mouseOutURL != null;
        }
        if (imageURL == null) {
            throw Tapestry.createRequiredParameterException(this, "image");
        }
        writer.beginEmpty("img");
        writer.attribute("src", imageURL);
        if (dynamic) {
            if (mouseOverURL == null) {
                mouseOverURL = imageURL;
            }
            if (mouseOutURL == null) {
                mouseOutURL = imageURL;
            }
            imageId = this.writeScript(cycle, pageRenderSupport, serviceLink, mouseOverURL, mouseOutURL);
            writer.attribute("id", imageId);
        }
        this.renderInformalParameters(writer, cycle);
        writer.closeTag();
    }

    public abstract IScript getScript();

    private String writeScript(IRequestCycle cycle, PageRenderSupport pageRenderSupport, ILinkComponent link, String mouseOverImageURL, String mouseOutImageURL) {
        String imageId = pageRenderSupport.getUniqueString(this.getId());
        String preloadedMouseOverImageURL = pageRenderSupport.getPreloadedImageReference(mouseOverImageURL);
        String preloadedMouseOutImageURL = pageRenderSupport.getPreloadedImageReference(mouseOutImageURL);
        HashMap<String, String> symbols = new HashMap<String, String>();
        symbols.put("imageId", imageId);
        symbols.put("mouseOverImageURL", preloadedMouseOverImageURL);
        symbols.put("mouseOutImageURL", preloadedMouseOutImageURL);
        this.getScript().execute(cycle, pageRenderSupport, symbols);
        link.addEventHandler(LinkEventType.MOUSE_OVER, (String)symbols.get("onMouseOverName"));
        link.addEventHandler(LinkEventType.MOUSE_OUT, (String)symbols.get("onMouseOutName"));
        return imageId;
    }

    public abstract IAsset getMouseOut();

    public abstract IAsset getDisabled();

    public abstract IAsset getMouseOver();

    public abstract IAsset getImage();
}

