/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.listener;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.IActionListener;
import org.apache.tapestry.listener.ListenerMap;
import org.apache.tapestry.listener.ListenerMessages;
import org.apache.tapestry.listener.ListenerMethodInvoker;
import org.apache.tapestry.listener.SyntheticListener;

public class ListenerMapImpl
implements ListenerMap {
    private final Object _target;
    private final Map _invokers;
    private final Map _listeners = new HashMap();

    public ListenerMapImpl(Object target, Map invokers) {
        Defense.notNull((Object)target, (String)"target");
        Defense.notNull((Object)invokers, (String)"invokers");
        this._target = target;
        this._invokers = invokers;
    }

    public boolean canProvideListener(String name) {
        return this._invokers.containsKey(name);
    }

    public synchronized IActionListener getListener(String name) {
        IActionListener result = (IActionListener)this._listeners.get(name);
        if (result == null) {
            result = this.createListener(name);
            this._listeners.put(name, result);
        }
        return result;
    }

    private IActionListener createListener(String name) {
        ListenerMethodInvoker invoker = (ListenerMethodInvoker)this._invokers.get(name);
        if (invoker == null) {
            throw new ApplicationRuntimeException(ListenerMessages.objectMissingMethod(this._target, name), this._target, null, null);
        }
        return new SyntheticListener(this._target, invoker);
    }

    public Collection getListenerNames() {
        return Collections.unmodifiableCollection(this._invokers.keySet());
    }
}

