/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.multipart;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.fileupload.FileItem;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.multipart.MultipartMessages;
import org.apache.tapestry.request.IUploadFile;

public class UploadPart
implements IUploadFile {
    private FileItem _fileItem;

    public UploadPart(FileItem fileItem) {
        Defense.notNull((Object)fileItem, (String)"fileItem");
        this._fileItem = fileItem;
    }

    public String getContentType() {
        return this._fileItem.getContentType();
    }

    public String getFileName() {
        File file = new File(this.getFilePath());
        return file.getName();
    }

    public String getFilePath() {
        return this._fileItem.getName();
    }

    public InputStream getStream() {
        try {
            return this._fileItem.getInputStream();
        }
        catch (IOException ex) {
            throw new ApplicationRuntimeException(MultipartMessages.unableToOpenContentFile(this, ex), (Throwable)ex);
        }
    }

    public void cleanup() {
        this._fileItem.delete();
    }

    public void write(File file) {
        try {
            this._fileItem.write(file);
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(Tapestry.format("UploadPart.write-failure", file, ex.getMessage()), (Throwable)ex);
        }
    }

    public long getSize() {
        return this._fileItem.getSize();
    }

    public boolean isInMemory() {
        return this._fileItem.isInMemory();
    }
}

