/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.parse;

import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.Location;
import org.apache.hivemind.util.ToStringBuilder;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRender;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.parse.ParseMessages;
import org.apache.tapestry.parse.TemplateToken;
import org.apache.tapestry.parse.TokenType;

public class TextToken
extends TemplateToken
implements IRender {
    private char[] _templateData;
    private int _offset;
    private int _length;

    public TextToken(char[] templateData, int startIndex, int endIndex, Location location) {
        super(TokenType.TEXT, location);
        if (startIndex < 0 || endIndex < 0 || startIndex > templateData.length || endIndex > templateData.length) {
            throw new ApplicationRuntimeException(ParseMessages.rangeError(this, templateData.length), (Object)this, this.getLocation(), null);
        }
        this._templateData = templateData;
        this._offset = startIndex;
        this._length = endIndex - startIndex + 1;
    }

    public void render(IMarkupWriter writer, IRequestCycle cycle) {
        if (this._length == 0) {
            return;
        }
        writer.printRaw(this._templateData, this._offset, this._length);
    }

    protected void extendDescription(ToStringBuilder builder) {
        builder.append("offset", this._offset);
        builder.append("length", this._length);
    }

    public String getTemplateDataAsString() {
        return new String(this._templateData, this._offset, this._length);
    }

    public int getLength() {
        return this._length;
    }

    public int getOffset() {
        return this._offset;
    }
}

