/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.services.impl;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.Messages;
import org.apache.hivemind.Resource;
import org.apache.hivemind.util.Defense;
import org.apache.hivemind.util.LocalizedNameGenerator;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.INamespace;
import org.apache.tapestry.event.ResetEventListener;
import org.apache.tapestry.services.ComponentMessagesSource;
import org.apache.tapestry.services.ComponentPropertySource;
import org.apache.tapestry.services.impl.ComponentMessages;
import org.apache.tapestry.services.impl.ImplMessages;
import org.apache.tapestry.services.impl.ResourceLocalization;
import org.apache.tapestry.util.text.LocalizedProperties;

public class ComponentMessagesSourceImpl
implements ComponentMessagesSource,
ResetEventListener {
    private Properties _emptyProperties = new Properties();
    private static final String SUFFIX = ".properties";
    public static final String MESSAGES_ENCODING_PROPERTY_NAME = "org.apache.tapestry.messages-encoding";
    private Map _componentCache = new HashMap();
    private ComponentPropertySource _componentPropertySource;

    protected synchronized Properties getLocalizedProperties(IComponent component) {
        Defense.notNull((Object)component, (String)"component");
        Resource specificationLocation = component.getSpecification().getSpecificationLocation();
        Locale locale = component.getPage().getLocale();
        Map propertiesMap = this.findPropertiesMapForResource(specificationLocation);
        Properties result = (Properties)propertiesMap.get(locale);
        if (result == null) {
            result = this.assembleComponentProperties(component, specificationLocation, propertiesMap, locale);
            propertiesMap.put(locale, result);
        }
        return result;
    }

    private Map findPropertiesMapForResource(Resource resource) {
        HashMap result = (HashMap)this._componentCache.get(resource);
        if (result == null) {
            result = new HashMap();
            this._componentCache.put(resource, result);
        }
        return result;
    }

    private Properties getNamespaceProperties(IComponent component, Locale locale) {
        INamespace namespace = component.getNamespace();
        Resource namespaceLocation = namespace.getSpecificationLocation();
        Map propertiesMap = this.findPropertiesMapForResource(namespaceLocation);
        Properties result = (Properties)propertiesMap.get(locale);
        if (result == null) {
            result = this.assembleNamespaceProperties(namespace, propertiesMap, locale);
            propertiesMap.put(locale, result);
        }
        return result;
    }

    private Properties assembleComponentProperties(IComponent component, Resource baseResourceLocation, Map propertiesMap, Locale locale) {
        List localizations = this.findLocalizationsForResource(baseResourceLocation, locale);
        Properties parent = null;
        Properties assembledProperties = null;
        Iterator i = localizations.iterator();
        while (i.hasNext()) {
            ResourceLocalization rl = (ResourceLocalization)i.next();
            Locale l = rl.getLocale();
            Properties namespaceProperties = this.getNamespaceProperties(component, l);
            assembledProperties = new Properties(namespaceProperties);
            Properties properties = this.readComponentProperties(component, l, rl.getResource(), null);
            if (parent != null) {
                if (properties != null) {
                    ((Hashtable)parent).putAll(properties);
                }
            } else {
                parent = properties;
            }
            if (parent != null) {
                ((Hashtable)assembledProperties).putAll(parent);
            }
            propertiesMap.put(l, assembledProperties);
        }
        return assembledProperties;
    }

    private Properties assembleNamespaceProperties(INamespace namespace, Map propertiesMap, Locale locale) {
        List localizations = this.findLocalizationsForResource(namespace.getSpecificationLocation(), locale);
        Properties parent = this._emptyProperties;
        Iterator i = localizations.iterator();
        while (i.hasNext()) {
            ResourceLocalization rl = (ResourceLocalization)i.next();
            Locale l = rl.getLocale();
            Properties properties = (Properties)propertiesMap.get(l);
            if (properties == null) {
                properties = this.readNamespaceProperties(namespace, l, rl.getResource(), parent);
                propertiesMap.put(l, properties);
            }
            parent = properties;
        }
        return parent;
    }

    private List findLocalizationsForResource(Resource resource, Locale locale) {
        ArrayList<ResourceLocalization> result = new ArrayList<ResourceLocalization>();
        String baseName = this.extractBaseName(resource);
        LocalizedNameGenerator g = new LocalizedNameGenerator(baseName, locale, SUFFIX);
        while (g.more()) {
            String localizedName = g.next();
            Locale l = g.getCurrentLocale();
            Resource localizedResource = resource.getRelativeResource(localizedName);
            result.add(new ResourceLocalization(l, localizedResource));
        }
        Collections.reverse(result);
        return result;
    }

    private String extractBaseName(Resource baseResourceLocation) {
        String fileName = baseResourceLocation.getName();
        int dotx = fileName.lastIndexOf(46);
        return fileName.substring(0, dotx);
    }

    private Properties readComponentProperties(IComponent component, Locale locale, Resource propertiesResource, Properties parent) {
        String encoding = this.getComponentMessagesEncoding(component, locale);
        return this.readPropertiesResource(propertiesResource.getResourceURL(), encoding, parent);
    }

    private Properties readNamespaceProperties(INamespace namespace, Locale locale, Resource propertiesResource, Properties parent) {
        String encoding = this.getNamespaceMessagesEncoding(namespace, locale);
        return this.readPropertiesResource(propertiesResource.getResourceURL(), encoding, parent);
    }

    private Properties readPropertiesResource(URL resourceURL, String encoding, Properties parent) {
        if (resourceURL == null) {
            return parent;
        }
        Properties result = new Properties(parent);
        LocalizedProperties wrapper = new LocalizedProperties(result);
        BufferedInputStream input = null;
        try {
            input = new BufferedInputStream(resourceURL.openStream());
            if (encoding == null) {
                wrapper.load(input);
            } else {
                wrapper.load(input, encoding);
            }
            ((InputStream)input).close();
            this.close(input);
        }
        catch (IOException ex) {
            try {
                throw new ApplicationRuntimeException(ImplMessages.unableToLoadProperties(resourceURL, ex), (Throwable)ex);
            }
            catch (Throwable throwable) {
                this.close(input);
                throw throwable;
            }
        }
        return result;
    }

    private void close(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public synchronized void resetEventDidOccur() {
        this._componentCache.clear();
    }

    public Messages getMessages(IComponent component) {
        return new ComponentMessages(component.getPage().getLocale(), this.getLocalizedProperties(component));
    }

    private String getComponentMessagesEncoding(IComponent component, Locale locale) {
        String encoding = this._componentPropertySource.getLocalizedComponentProperty(component, locale, MESSAGES_ENCODING_PROPERTY_NAME);
        if (encoding == null) {
            encoding = this._componentPropertySource.getLocalizedComponentProperty(component, locale, "org.apache.tapestry.template-encoding");
        }
        return encoding;
    }

    private String getNamespaceMessagesEncoding(INamespace namespace, Locale locale) {
        return this._componentPropertySource.getLocalizedNamespaceProperty(namespace, locale, MESSAGES_ENCODING_PROPERTY_NAME);
    }

    public void setComponentPropertySource(ComponentPropertySource componentPropertySource) {
        this._componentPropertySource = componentPropertySource;
    }
}

