/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.services.impl;

import org.apache.hivemind.Location;
import org.apache.hivemind.Resource;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.IAsset;
import org.apache.tapestry.asset.AssetSource;
import org.apache.tapestry.engine.ISpecificationSource;
import org.apache.tapestry.services.NamespaceResources;
import org.apache.tapestry.spec.IComponentSpecification;
import org.apache.tapestry.spec.ILibrarySpecification;

public class NamespaceResourcesImpl
implements NamespaceResources {
    private final ISpecificationSource _specificationSource;
    private final AssetSource _assetSource;

    public NamespaceResourcesImpl(ISpecificationSource source, AssetSource assetSource) {
        Defense.notNull((Object)source, (String)"source");
        Defense.notNull((Object)assetSource, (String)"assetSource");
        this._specificationSource = source;
        this._assetSource = assetSource;
    }

    public ILibrarySpecification findChildLibrarySpecification(Resource parentResource, String path, Location location) {
        Resource childResource = this.findSpecificationResource(parentResource, path, location);
        return this._specificationSource.getLibrarySpecification(childResource);
    }

    private Resource findSpecificationResource(Resource libraryResource, String path, Location location) {
        IAsset childAsset = this._assetSource.findAsset(libraryResource, path, null, location);
        Resource childResource = childAsset.getResourceLocation();
        return childResource;
    }

    public IComponentSpecification getPageSpecification(Resource resource, String specificationPath, Location location) {
        Resource pageSpecificationResource = this.findSpecificationResource(resource, specificationPath, location);
        return this._specificationSource.getPageSpecification(pageSpecificationResource);
    }

    public IComponentSpecification getComponentSpecification(Resource resource, String specificationPath, Location location) {
        Resource componentSpecificationResource = this.findSpecificationResource(resource, specificationPath, location);
        return this._specificationSource.getComponentSpecification(componentSpecificationResource);
    }
}

