/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.services.impl;

import java.util.Iterator;
import org.apache.hivemind.ErrorHandler;
import org.apache.tapestry.IEngine;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.engine.IMonitor;
import org.apache.tapestry.engine.IMonitorFactory;
import org.apache.tapestry.engine.RequestCycle;
import org.apache.tapestry.engine.RequestCycleEnvironment;
import org.apache.tapestry.engine.ServiceEncoder;
import org.apache.tapestry.engine.ServiceEncodingImpl;
import org.apache.tapestry.record.PropertyPersistenceStrategySource;
import org.apache.tapestry.request.RequestContext;
import org.apache.tapestry.services.AbsoluteURLBuilder;
import org.apache.tapestry.services.Infrastructure;
import org.apache.tapestry.services.RequestCycleFactory;
import org.apache.tapestry.services.RequestGlobals;
import org.apache.tapestry.util.QueryParameterMap;
import org.apache.tapestry.web.WebRequest;

public class RequestCycleFactoryImpl
implements RequestCycleFactory {
    private ServiceEncoder[] _encoders;
    private IMonitorFactory _monitorFactory;
    private PropertyPersistenceStrategySource _strategySource;
    private ErrorHandler _errorHandler;
    private Infrastructure _infrastructure;
    private AbsoluteURLBuilder _absoluteURLBuilder;
    private RequestCycleEnvironment _environment;
    private RequestGlobals _requestGlobals;

    public void initializeService() {
        this._environment = new RequestCycleEnvironment(this._errorHandler, this._infrastructure, this._strategySource, this._absoluteURLBuilder);
    }

    public IRequestCycle newRequestCycle(IEngine engine) {
        RequestContext context = new RequestContext(this._requestGlobals.getRequest(), this._requestGlobals.getResponse());
        WebRequest request = this._infrastructure.getRequest();
        IMonitor monitor = this._monitorFactory.createMonitor(request);
        QueryParameterMap parameters = this.extractParameters(request);
        this.decodeParameters(request.getActivationPath(), request.getPathInfo(), parameters);
        String serviceName = this.findService(parameters);
        RequestCycle cycle = new RequestCycle(engine, parameters, serviceName, monitor, this._environment, context);
        this._requestGlobals.store(cycle);
        return cycle;
    }

    private String findService(QueryParameterMap parameters) {
        String serviceName = parameters.getParameterValue("service");
        return serviceName == null ? "home" : serviceName;
    }

    private QueryParameterMap extractParameters(WebRequest request) {
        QueryParameterMap result = new QueryParameterMap();
        Iterator i = request.getParameterNames().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            String[] values = request.getParameterValues(name);
            if (values.length == 1) {
                result.setParameterValue(name, values[0]);
                continue;
            }
            result.setParameterValues(name, values);
        }
        return result;
    }

    private void decodeParameters(String servletPath, String pathInfo, QueryParameterMap map) {
        ServiceEncodingImpl se = new ServiceEncodingImpl(servletPath, pathInfo, map);
        for (int i = 0; i < this._encoders.length; ++i) {
            this._encoders[i].decode(se);
            if (!se.isModified()) continue;
            return;
        }
    }

    public void setEncoders(ServiceEncoder[] encoders) {
        this._encoders = encoders;
    }

    public void setMonitorFactory(IMonitorFactory monitorFactory) {
        this._monitorFactory = monitorFactory;
    }

    public void setStrategySource(PropertyPersistenceStrategySource strategySource) {
        this._strategySource = strategySource;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this._errorHandler = errorHandler;
    }

    public void setInfrastructure(Infrastructure infrastructure) {
        this._infrastructure = infrastructure;
    }

    public void setAbsoluteURLBuilder(AbsoluteURLBuilder absoluteURLBuilder) {
        this._absoluteURLBuilder = absoluteURLBuilder;
    }

    public void setRequestGlobals(RequestGlobals requestGlobals) {
        this._requestGlobals = requestGlobals;
    }
}

