/*
 * Decompiled with CFR 0.152.
 */
package jp.wda.gpss;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Hashtable;
import java.util.Set;
import jp.wda.gpss.AttributeException;
import jp.wda.gpss.SocketProcessor;
import jp.wda.gpss.Socklet;
import jp.wda.gpss.system.InitParamContainerImpl;
import jp.wda.gpss.util.PseudoUUID;

public class DummyClient
extends InitParamContainerImpl
implements SocketProcessor,
Serializable {
    private boolean terminated = false;
    private String clientid;
    private String username;
    private String password;
    private String ipaddr = InetAddress.getLocalHost().getHostAddress();
    private Socklet application = null;
    private Hashtable attributes = null;

    public DummyClient() throws IOException {
        this.setClientID(new PseudoUUID(this.ipaddr).toString());
        this.attributes = new Hashtable();
    }

    public DummyClient(String clientid) throws IOException {
        this();
        this.setClientID(clientid);
    }

    public String getClientID() {
        return this.clientid;
    }

    private void setClientID(String s) {
        this.clientid = s;
    }

    public String getEncoding() {
        return null;
    }

    public String getUserName() {
        return this.username;
    }

    public void setUserName(String s) {
        this.username = s;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String s) {
        this.password = s;
    }

    public String getIPAddress() {
        return this.ipaddr;
    }

    Socklet getApplication() {
        return this.application;
    }

    public void setApplication(Socklet s) {
        this.application = s;
    }

    public void setAttribute(Object key, Object value) {
        this.attributes.put(key, value);
    }

    public Object getAttribute(Object key) {
        return this.attributes.get(key);
    }

    public Set getAttributes() {
        return this.attributes.entrySet();
    }

    public boolean containsAttributeKey(Object key) {
        return this.attributes.containsKey(key);
    }

    public Set getAttributeKeys() {
        return this.attributes.keySet();
    }

    public Object removeAttribute(Object key) {
        return this.attributes.remove(key);
    }

    public final void setAttribute(Object key, int value) {
        this.attributes.put(key, new Integer(value));
    }

    public final int getAttributeInt(Object key) throws AttributeException {
        Object ret = this.attributes.get(key);
        if (ret instanceof Integer) {
            return (Integer)ret;
        }
        throw new AttributeException("\u6307\u5b9a\u3055\u308c\u305f\u5c5e\u6027(" + key + ")\u306fint\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
    }

    public final void setAttribute(Object key, long value) {
        this.attributes.put(key, new Long(value));
    }

    public final long getAttributeLong(Object key) throws AttributeException {
        Object ret = this.attributes.get(key);
        if (ret instanceof Long) {
            return (Long)ret;
        }
        throw new AttributeException("\u6307\u5b9a\u3055\u308c\u305f\u5c5e\u6027(" + key + ")\u306flong\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
    }

    public final void setAttribute(Object key, double value) {
        this.attributes.put(key, new Double(value));
    }

    public final double getAttributeDouble(Object key) throws AttributeException {
        Object ret = this.attributes.get(key);
        if (ret instanceof Double) {
            return (Double)ret;
        }
        throw new AttributeException("\u6307\u5b9a\u3055\u308c\u305f\u5c5e\u6027(" + key + ")\u306fdouble\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
    }

    public final void setAttribute(Object key, boolean value) {
        this.attributes.put(key, new Boolean(value));
    }

    public final boolean getAttributeBoolean(Object key) throws AttributeException {
        Object ret = this.attributes.get(key);
        if (ret instanceof Boolean) {
            return (Boolean)ret;
        }
        throw new AttributeException("\u6307\u5b9a\u3055\u308c\u305f\u5c5e\u6027(" + key + ")\u306fboolean\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
    }

    public boolean send(String message) {
        return true;
    }

    public void terminate() {
        this.terminated = true;
    }

    public void terminate(String message) {
        this.terminate();
    }

    public boolean isTerminated() {
        return this.terminated;
    }
}

