/*
 * Decompiled with CFR 0.152.
 */
package jp.wda.gpss.samples;

import java.util.List;
import java.util.Map;
import jp.wda.gpss.GeneralSocklet;
import jp.wda.gpss.SocketProcessor;
import jp.wda.gpss.SockletDeployInfo;
import jp.wda.gpss.samples.ContoroledChatSampleRoomsAdministrator;

public class ContoroledChatSample
extends GeneralSocklet {
    public static final String ADMIN_FOTTER = "_Admin";
    public static final String INIT_ROOM_KEY = "room";
    public static final String P_INIT_ROOM_KEY = "p.room";
    public String adminSockletName = null;
    private ContoroledChatSampleRoomsAdministrator adminSocklet;

    protected void init(List linkedSocklets) {
        this.adminSockletName = String.valueOf(this.getName()) + ADMIN_FOTTER;
        SockletDeployInfo appinfo = this.copyInfo(this.adminSockletName, "jp.wda.gpss.samples.ContoroledChatSampleRoomsAdministrator");
        appinfo.setTimeout(0);
        linkedSocklets.add(appinfo);
    }

    public void afterDeployedLinks(Map linkedSocklets) {
        this.adminSocklet = (ContoroledChatSampleRoomsAdministrator)linkedSocklets.get(this.adminSockletName);
    }

    public boolean checkConnection(SocketProcessor client) {
        String roomname = client.getInitParam(INIT_ROOM_KEY);
        Boolean loginFailure = new Boolean(false);
        client.setAttribute((Object)"loginFailure", Boolean.FALSE);
        List cls = this.getClients("username==\"" + client.getUserName() + "\"&" + P_INIT_ROOM_KEY + "==\"" + roomname + "\"");
        if (cls.size() > 1) {
            client.send("-Login failure user \"" + client.getUserName() + "\"");
            client.setAttribute((Object)"loginFailure", Boolean.TRUE);
            this.chatlog(roomname, client.getUserName(), "\u30ed\u30b0\u30a4\u30f3\u5931\u6557\u3067\u3059\u3002");
            return false;
        }
        client.send("+OK welcome user \"" + client.getUserName() + "\"");
        this.sendToClients(String.valueOf(client.getUserName()) + "\u3055\u3093\u304c" + roomname + "\u306b\u5165\u5ba4\u3057\u307e\u3057\u305f", "p.room==\"" + roomname + "\"&username!=\"" + client.getUserName() + "\"");
        if (this.adminSocklet != null) {
            int members = this.adminSocklet.addToRoom(roomname);
            if (members == 1) {
                this.chatlog(roomname, client.getUserName(), "<<\u958b\u8a2d\u3057\u307e\u3057\u305f>>");
            } else {
                this.chatlog(roomname, client.getUserName(), "<<\u5165\u5ba4\u3057\u307e\u3057\u305f>>");
            }
        }
        return true;
    }

    public void preRemoveClient(SocketProcessor client) {
        if (((Boolean)client.getAttribute("loginFailure")).booleanValue()) {
            return;
        }
        String roomname = client.getInitParam(INIT_ROOM_KEY);
        this.sendToClients(String.valueOf(client.getUserName()) + "\u3055\u3093\u304c" + roomname + "\u3092\u9000\u5ba4\u3057\u307e\u3057\u305f", "p.room==\"" + roomname + "\"");
        if (this.adminSocklet != null) {
            int members = this.adminSocklet.removeFromRoom(roomname);
            if (members == 0) {
                this.chatlog(roomname, client.getUserName(), "<<\u9589\u9396\u3057\u307e\u3057\u305f>>");
            } else {
                this.chatlog(roomname, client.getUserName(), "<<\u9000\u5ba4\u3057\u307e\u3057\u305f>>");
            }
        }
    }

    public boolean doCommand(SocketProcessor client, String command) {
        if (((Boolean)client.getAttribute("loginFailure")).booleanValue()) {
            return false;
        }
        String roomname = client.getInitParam(INIT_ROOM_KEY);
        this.sendToClients(String.valueOf(client.getUserName()) + " : " + command, "p.room==\"" + roomname + "\"");
        this.chatlog(roomname, client.getUserName(), command);
        return true;
    }

    private void chatlog(String room, String user, String memo) {
        this.log(String.valueOf(room) + "," + user + "," + memo);
    }
}

