/*
 * Decompiled with CFR 0.152.
 */
package jp.wda.gpss.util;

import java.io.IOException;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class PseudoUUID {
    private static String hostaddress;
    private static int hostUnique;
    private static Object mutex;
    private static long lastTime;
    private static long DELAY;
    private static MessageDigest md;
    private int unique;
    private long time;
    private String address;

    static {
        hostUnique = new Object().hashCode();
        mutex = new Object();
        lastTime = System.currentTimeMillis();
        DELAY = 10L;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            md = null;
        }
        try {
            String s = InetAddress.getLocalHost().getHostAddress();
            hostaddress = PseudoUUID.MD5(s);
        }
        catch (Throwable ex) {
            hostaddress = PseudoUUID.generateNoNetworkID();
        }
    }

    public PseudoUUID() throws IOException {
        this(null);
    }

    public PseudoUUID(String clientaddr) throws IOException {
        if (md == null) {
            throw new IOException("MD5\u30a2\u30eb\u30b4\u30ea\u30ba\u30e0\u304c\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        Object object = mutex;
        synchronized (object) {
            this.set1st();
            this.set2nd();
            this.set3rd(clientaddr);
        }
    }

    public String get1st() {
        return Integer.toHexString(this.unique);
    }

    private void set1st() {
        this.unique = hostUnique;
    }

    public String get2nd() {
        return Long.toHexString(this.time);
    }

    private void set2nd() {
        while (true) {
            this.time = System.currentTimeMillis();
            if (this.time >= lastTime + DELAY) break;
            try {
                Thread.sleep(DELAY);
            }
            catch (InterruptedException interruptedException) {}
        }
        lastTime = this.time;
    }

    public String get3rd() {
        return this.address;
    }

    public void set3rd(String addr) {
        this.address = addr == null ? hostaddress : PseudoUUID.MD5(addr);
    }

    public String toString() {
        return String.valueOf(this.get1st()) + "-" + this.get2nd() + "-" + this.get3rd();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof PseudoUUID) {
            PseudoUUID uuid = (PseudoUUID)obj;
            return this.unique == uuid.unique && this.time == uuid.time && this.address.equals(uuid.address);
        }
        return false;
    }

    public static String MD5(String val) {
        if (val == null) {
            return null;
        }
        if (md == null) {
            return null;
        }
        byte[] digest = md.digest(val.getBytes());
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < digest.length) {
            s.append(Integer.toHexString((digest[i] & 0xF0) >> 4));
            s.append(Integer.toHexString(digest[i] & 0xF));
            ++i;
        }
        return s.toString();
    }

    private static String generateNoNetworkID() {
        Thread current = Thread.currentThread();
        String nid = String.valueOf(Thread.activeCount()) + System.getProperty("os.version") + System.getProperty("user.name") + System.getProperty("java.version");
        System.out.println(nid);
        return PseudoUUID.MD5(nid);
    }

    public static void main(String[] args) {
        try {
            System.out.println(InetAddress.getLocalHost().getHostAddress());
            System.out.println(new PseudoUUID());
            System.out.println(new PseudoUUID());
            System.out.println(new PseudoUUID());
            System.out.println(new PseudoUUID());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

