#include "SockletService1.04.as"

service = new SockletService("auto", "port.txt", "xml", "plain");
service.connectionFailure = _root.connectionFailure;
service.onClose = _root.onClose;

aIndent = "                           ";
eIndent = "                           ";
listStyle = new FStyleFormat();
listStyle.textFont = "_";

selfX = 0;
selfY = 0;
depth = 100;
iLock = false;

STAGE_WIDTH  = 39;
STAGE_HEIGHT = 19;

messages = new Array();

// ----------------------------------------------
// SockletT[oؒfCxgnh
// ----------------------------------------------
function onClose(){
	trace (this.socklet + " is disconnected.");
	gotoAndStop("failure4");
}

// ----------------------------------------------
// SockletT[oւ̐ڑsCxgnh
// ----------------------------------------------
function connectionFailure(status){
	service.onClose = null;
	
	if(status == 0){
		trace("connection failure...");
		gotoAndStop("failure1");
	}else if(status == 16){
		trace("I can't get port... : (" + this.port + ")...");
		gotoAndStop("failure2");
	}else{
		trace("login failure...");
		gotoAndStop("failure3");
	}
}

// -----------------------------------------
// ΐCԕύXʒmCxgnh
// -----------------------------------------
function onNotifyArea(receive){
	var root = receive.firstChild;
	if(root.nodeName != "area"){
		trace(receive.toString());
		return;
	}
	var areaname = root.attributes["name"];
	var users    = root.attributes["users"];
	
	for(var i = 0; i < areaList.getLength(); i++){
		var item = areaList.getItemAt(i);
		if(item.data == null){
			areaList.removeItemAt(i);
			continue;
		}
		if(item.data == areaname){
			areaList.replaceItemAt(i, getAreaListLabel(areaname, users), areaname);
			return;
		}
	}
	areaList.addItem(getAreaListLabel(areaname, users), areaname);
}
function getAreaListLabel(name, members){
	var length = name.length;
	for(var i = 0; i < name.length; i++){
		if(name.charCodeAt(i) > 255){ length++; }
	}
	if(length > aIndent.length){
		name = name.substr(0, aIndent.length - 3) + "...";
	}
	return name + aIndent.substr(length) + "|Q :" + members + "l";
}

// -----------------------------------------
// ΐCICxgnh
// -----------------------------------------
function onSelectArea(cmp){
	if(cmp.getSelectedItem().data != null){
		tfLOArea = cmp.getSelectedItem().data;
	}else{
		tfLOArea = "";
	}
}

// -----------------------------------------
// J[\p\bh
// -----------------------------------------
function setFireCursol(){
	var x = Math.floor(_root._xmouse / this._width);
	var y = Math.floor(_root._ymouse / this._height);
	if(x == _root.selfX && y == _root.selfY){ return; }
	
	var xx = _root.selfX; xx++;
	var yy = _root.selfY; yy++
	if(_root.selfX - 1 <= x && xx >= x && _root.selfY - 1 <= y && yy >= y){
		this.command = "move:";
	}else{
		this.command = "fire:";
	}
	
	if(x <= 0){ x = 0; }else if(x >= STAGE_WIDTH) { x = STAGE_WIDTH; }
	if(y <= 0){ y = 0; }else if(y >= STAGE_HEIGHT){ y = STAGE_HEIGHT; }
	x *= this._width;
	y *= this._height;
	
	this._x = x;
	this._y = y;
}

// ----------------------------------------------
// SockletT[oOCCxgnh
// ----------------------------------------------
function onLoginSuccessfully(){
	this.onReceive = _root.onReceive;
	this.send("init:");
	gotoAndStop("MainField");
}

command = new Object();

// -----------------------------------------
// onReceiveCxgnh
// -----------------------------------------
function onReceive(receive){
	var root = receive.firstChild;
	var cmdName = root.nodeName;
	if(command[cmdName] != undefined){
		return command[cmdName](root);
	}else{
		trace(receive.toString());
	}
}

// -----------------------------------------
// ݒCxgnh
// -----------------------------------------
command.INIT = function(xml){
	tfMArea     = xml.attributes["area"] + "̐킢";
	tfMUsername = xml.attributes["name"];
	tfMPoint    = xml.attributes["point"];

	_root.selfX = xml.attributes["x"];
	_root.selfY = xml.attributes["y"];
	mcMyself._x = _root.selfX * mcFireCursol._width;
	mcMyself._y = _root.selfY * mcFireCursol._height;
}

// -----------------------------------------
// T[obZ[WCxgnh
// -----------------------------------------
command.NOTIFY = function(xml){
	var point  = parseInt(xml.attributes["point"]);
	var status = parseInt(xml.attributes["status"]);
	var option = xml.attributes["option"];
	if(isNaN(point)){ ; }else{ tfMPoint = point; }
	
	trace("Status : " + status);
	switch(status){
		case 8:  this.setMessage("e܂B{[iXPT=" + option, "990000"); return;
		case 16: this.setMessage("e܂B", "338855"); return;
		case 32: return;
		default: this.setMessage(xml.attributes["message"], "000099"); return;
	}
}

command.setMessage = function(message, color){
	messages.unshift(message);
	if(messages.length > 4){ messages.pop(); }
	
	var str = "<FONT COLOR=\"#" + color + "\"><B>" + messages[0] + "</B></FONT><BR>";
	for(var i = 1; i < messages.length; i++){
		str += "<FONT COLOR=\"#777777\">" + messages[i] + "</FONT><BR>";
	}
	trace(str);
	tfMMessage = str;
}

// -----------------------------------------
// G͏ԕύXʒmCxgnh
// -----------------------------------------
command.ENEMY = function(xml){
	var name  = xml.attributes["name"];
	var point = xml.attributes["point"];
	
	for(var i = 0; i < enemyList.getLength(); i++){
		var item = enemyList.getItemAt(i);
		if(item.data == name){
			if(isNaN(point)){
				enemyList.removeItemAt(i);
			}else{
				enemyList.replaceItemAt(i, this.getEnemyListLabel(name, point), name);
			}
			return;
		}
	}
	if(!isNaN(point)){
		enemyList.addItem(this.getEnemyListLabel(name, point), name);
	}
}
command.getEnemyListLabel = function(name, point){
	var length = name.length;
	for(var i = 0; i < name.length; i++){
		if(name.charCodeAt(i) > 255){ length++; }
	}
	if(length > eIndent.length){
		name = name.substr(0, eIndent.length - 3) + "...";
	}
	return name + eIndent.substr(length) + "|   " + point + "pt.";
}

// -----------------------------------------
// ͈ړ\bh
// -----------------------------------------
command.MOVE = function(xml){
	_root.selfX = xml.attributes["x"];;
	_root.selfY = xml.attributes["y"];;
	mcMyself._x = _root.selfX * mcFireCursol._width;
	mcMyself._y = _root.selfY * mcFireCursol._height;
	_root.iLock = false;
}

// -----------------------------------------
// Q[Iʒm\bh
// -----------------------------------------
command.GAMEOVER = function(xml){
	gotoAndStop("gameover");
}

// -----------------------------------------
// CΌʕ\\bh
// -----------------------------------------
command.FIRE_RESULT = function(xml){
	mcFire.duplicateMovieClip("fireResult" + depth, depth);
	var dup = eval("fireResult" + depth++);
	if(depth > 200){ depth = 100; }
	
	if(xml.attributes["hit"] > 0){
		dup.frameHit._visible = true;
	}else{
		dup.frameHit._visible = false;
	}
	with(dup){
		_x = mcFireCursol._width  * xml.attributes["x"];
		_y = mcFireCursol._height * xml.attributes["y"];
		_visible = true;
		_alpha = 100;
		gotoAndPlay(2);
	}
	this.setFireFrameColor(dup.frame1, xml.attributes["f1"]);
	this.setFireFrameColor(dup.frame2, xml.attributes["f2"]);
	
	_root.iLock = false;
}
command.setFireFrameColor = function(mc, num){
	if(num > 0){
		var g = 0;
  		if(num < 10){ g = ((10 - num) * 28) << 8; }
		c = new Color(mc);
		c.setRGB(0xff0000 + g);
	}else{
		mc._visible = false;
	}
}

// -----------------------------------------
// CΌʕ\\bh
// -----------------------------------------
command.FIRED = function(xml){
	mcFired.duplicateMovieClip("fired" + depth, depth);
	var dup = eval("fired" + depth++);
	if(depth > 200){ depth = 100; }
	
	with(dup){
		_x = mcFireCursol._width  * xml.attributes["x"];
		_y = mcFireCursol._height * xml.attributes["y"];
		_alpha = 100;
		direction._rotation = xml.attributes["dir"];
		
		gotoAndPlay(2);
	}
}
