/*
 * Decompiled with CFR 0.152.
 */
package jp.wda.g2.extention.socklet;

import java.io.Serializable;
import java.nio.ByteBuffer;
import jp.wda.g2.SocketProcessor;
import jp.wda.g2.Socklet;
import jp.wda.g2.SockletRequest;
import jp.wda.g2.exception.CommandNotFoundException;
import jp.wda.g2.exception.GPSSException;
import jp.wda.g2.extention.socklet.CommandRequestImpl;
import jp.wda.g2.extention.socklet.IXmlCommandSocklet;
import jp.wda.g2.extention.socklet.XMLCommandRequest;
import jp.wda.g2.system.SockletLinkage;
import jp.wda.g2.util.SimpleXMLCreator;

public class XMLCommandRequestImpl
extends CommandRequestImpl
implements XMLCommandRequest,
Serializable {
    private static final long serialVersionUID = 744644202132758997L;
    private SimpleXMLCreator xml = null;

    public XMLCommandRequestImpl(SocketProcessor client, ByteBuffer rawCommand, SockletLinkage linkage) {
        super(client, rawCommand, linkage);
    }

    public XMLCommandRequestImpl(SockletRequest request) {
        super(request);
    }

    public SimpleXMLCreator getXml() {
        return this.xml;
    }

    void setXml(SimpleXMLCreator s) {
        this.xml = s;
        this.setParams(new Object[]{this, this.xml});
    }

    public Object handoverRequest() throws GPSSException {
        if (!this.getLinkage().hasNext()) {
            throw new CommandNotFoundException(this.getName());
        }
        SockletLinkage next = this.getLinkage().getNext();
        Socklet socklet = next.getSocklet();
        if (socklet instanceof IXmlCommandSocklet) {
            this.setLinkage(next);
            return ((IXmlCommandSocklet)socklet).doCommandMethod(this);
        }
        return next.doCommand(this.getRawCommand());
    }
}

