/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.mail.Address;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;

public class InternetAddress
extends Address
implements Cloneable {
    protected String address;
    protected String encodedPersonal;
    protected String personal;
    private static final byte[] CHARMAP = new byte[]{2, 2, 2, 2, 2, 2, 2, 2, 6, 2, 6, 2, 2, 6, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2};
    private static final byte FLG_SPECIAL = 1;
    private static final byte FLG_CONTROL = 2;
    private static final byte FLG_SPACE = 4;

    public InternetAddress() {
    }

    public InternetAddress(String address) throws AddressException {
        this(address, true);
    }

    public InternetAddress(String address, boolean strict) throws AddressException {
        InternetAddress.init(this, address);
        if (strict) {
            this.validate();
        }
    }

    public InternetAddress(String address, String personal) throws UnsupportedEncodingException {
        this(address, personal, null);
    }

    public InternetAddress(String address, String personal, String charset) throws UnsupportedEncodingException {
        this.address = address;
        this.setPersonal(personal, charset);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error();
        }
    }

    public String getType() {
        return "rfc822";
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setPersonal(String name, String charset) throws UnsupportedEncodingException {
        this.encodedPersonal = MimeUtility.encodeWord(name, charset, null);
        this.personal = name;
    }

    public void setPersonal(String name) throws UnsupportedEncodingException {
        this.encodedPersonal = MimeUtility.encodeWord(name);
        this.personal = name;
    }

    public String getAddress() {
        return this.address;
    }

    public String getPersonal() {
        if (this.personal == null && this.encodedPersonal != null) {
            try {
                this.personal = MimeUtility.decodeWord(this.encodedPersonal);
            }
            catch (ParseException e) {
                return this.encodedPersonal;
            }
            catch (UnsupportedEncodingException e) {
                return this.encodedPersonal;
            }
        }
        return this.personal;
    }

    private String getEncodedPersonal() {
        if (this.encodedPersonal == null && this.personal != null) {
            try {
                this.encodedPersonal = MimeUtility.encodeWord(this.personal);
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }
        return this.encodedPersonal;
    }

    private StringBuffer quote(StringBuffer buf, String text) {
        int i;
        boolean noQuotesNeeded = true;
        for (i = 0; i < text.length() && noQuotesNeeded; ++i) {
            noQuotesNeeded = InternetAddress.isAtom(text.charAt(i));
        }
        if (noQuotesNeeded) {
            buf.append(text);
        } else {
            buf.append('\"');
            for (i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (c == '\"' || c == '\\') {
                    buf.append('\\');
                }
                buf.append(c);
            }
            buf.append('\"');
        }
        return buf;
    }

    public String toString() {
        String p = this.getEncodedPersonal();
        if (p == null) {
            return this.address;
        }
        StringBuffer buf = new StringBuffer(p.length() + 8 + this.address.length() + 3);
        this.quote(buf, p).append("< ").append(this.address).append(">");
        return buf.toString();
    }

    public String toUnicodeString() {
        String p = this.getPersonal();
        if (p == null) {
            return this.address;
        }
        StringBuffer buf = new StringBuffer(p.length() + 8 + this.address.length() + 3);
        this.quote(buf, p).append("< ").append(this.address).append(">");
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InternetAddress)) {
            return false;
        }
        InternetAddress other = (InternetAddress)o;
        String myAddress = this.getAddress();
        return myAddress == null ? other.getAddress() == null : myAddress.equalsIgnoreCase(other.getAddress());
    }

    public int hashCode() {
        return this.address == null ? 0 : this.address.toLowerCase().hashCode();
    }

    public boolean isGroup() {
        if (this.address == null) {
            return false;
        }
        int start = this.skipSpace(this.address, 0);
        int index = this.expectPhrase(this.address, start);
        if (index > start) {
            start = this.skipSpace(this.address, index);
        }
        return this.address.charAt(start) == ':' && this.address.charAt(this.address.length() - 1) == ';';
    }

    public InternetAddress[] getGroup(boolean strict) throws AddressException {
        if (this.address == null) {
            return null;
        }
        int start = this.skipSpace(this.address, 0);
        int index = this.expectPhrase(this.address, start);
        if (index == start && strict) {
            throw new AddressException("Missing phrase");
        }
        if (index > start) {
            start = this.skipSpace(this.address, index);
        }
        if (this.address.charAt(start) == ':' && this.address.charAt(this.address.length() - 1) == ';') {
            return InternetAddress.parseHeader(this.address.substring(1, this.address.length() - 1), strict);
        }
        return null;
    }

    public static InternetAddress getLocalAddress(Session session) {
        String host;
        String user;
        String address = null;
        if (session != null && (address = session.getProperty("mail.from")) == null) {
            user = session.getProperty("mail.user");
            host = session.getProperty("mail.host");
            if (user != null && host != null) {
                address = user + '@' + host;
            }
        }
        if (address == null) {
            try {
                user = System.getProperty("user.name");
                host = InetAddress.getLocalHost().getHostName();
                if (user != null && host != null) {
                    address = user + '@' + host;
                }
            }
            catch (UnknownHostException e) {
            }
            catch (SecurityException e) {
                // empty catch block
            }
        }
        if (address != null) {
            try {
                return new InternetAddress(address);
            }
            catch (AddressException addressException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String toString(Address[] addresses) {
        if (addresses == null || addresses.length == 0) {
            return null;
        }
        if (addresses.length == 1) {
            return addresses[0].toString();
        }
        StringBuffer buf = new StringBuffer(addresses.length * 32);
        buf.append(addresses[0].toString());
        for (int i = 1; i < addresses.length; ++i) {
            buf.append(", ");
            buf.append(addresses[i].toString());
        }
        return buf.toString();
    }

    public static String toString(Address[] addresses, int used) {
        if (addresses == null || addresses.length == 0) {
            return null;
        }
        if (addresses.length == 1) {
            String s = addresses[0].toString();
            if (used + s.length() > 72) {
                s = "\r\n  " + s;
            }
            return s;
        }
        StringBuffer buf = new StringBuffer(addresses.length * 32);
        for (int i = 0; i < addresses.length; ++i) {
            String s = addresses[1].toString();
            if (i == 0) {
                if (used + s.length() + 1 > 72) {
                    buf.append("\r\n  ");
                    used = 2;
                }
            } else if (used + s.length() + 1 > 72) {
                buf.append(",\r\n  ");
                used = 2;
            } else {
                buf.append(", ");
                used += 2;
            }
            buf.append(s);
            used += s.length();
        }
        return buf.toString();
    }

    public static InternetAddress[] parse(String addresses) throws AddressException {
        return InternetAddress.parse(addresses, true, false);
    }

    public static InternetAddress[] parse(String addresses, boolean strict) throws AddressException {
        return InternetAddress.parse(addresses, strict, false);
    }

    public static InternetAddress[] parseHeader(String addresses, boolean strict) throws AddressException {
        return InternetAddress.parse(addresses, strict, true);
    }

    private static InternetAddress[] parse(String addresses, boolean strict, boolean veryStrict) throws AddressException {
        ArrayList addrs = new ArrayList();
        InternetAddress.parseHeader(addrs, addresses, strict, veryStrict);
        return addrs.toArray(new InternetAddress[addrs.size()]);
    }

    static void parseHeader(List target, String addresses, boolean strict, boolean veryStrict) throws AddressException {
        StringTokenizer tok = new StringTokenizer(addresses, ",");
        while (tok.hasMoreTokens()) {
            String text = tok.nextToken().trim();
            InternetAddress addr = new InternetAddress();
            InternetAddress.init(addr, text);
            if (strict || veryStrict) {
                addr.validate();
            }
            target.add(addr);
        }
    }

    private static void init(InternetAddress addr, String text) {
        addr.address = text;
        addr.personal = null;
        addr.encodedPersonal = null;
    }

    public void validate() throws AddressException {
    }

    private int expectPhrase(String s, int index) {
        int start = index;
        index = this.expectWord(s, index);
        while (index != start) {
            start = this.skipSpace(s, index);
            index = this.expectWord(s, start);
        }
        return index;
    }

    private int expectWord(String s, int index) {
        if (index == s.length()) {
            return index;
        }
        char c = s.charAt(index);
        if (c == '\"') {
            ++index;
            while (index < s.length()) {
                c = s.charAt(index);
                if (c == '\"') {
                    ++index;
                    break;
                }
                if (c == '\\') {
                    if (index != s.length()) {
                        ++index;
                    }
                } else if (c == '\r') {
                    return index;
                }
                ++index;
            }
        } else {
            while (index < s.length() && InternetAddress.isAtom(s.charAt(index))) {
                ++index;
            }
        }
        return index;
    }

    private int skipSpace(String s, int index) {
        while (index < s.length()) {
            char c = s.charAt(index);
            if (InternetAddress.isSpace(c)) {
                ++index;
                continue;
            }
            if (c == '(') {
                index = this.skipComment(s, index);
                continue;
            }
            return index;
        }
        return index;
    }

    private int skipComment(String s, int index) {
        ++index;
        int nest = 1;
        while (index < s.length() && nest > 0) {
            char c;
            if ((c = s.charAt(index++)) == ')') {
                --nest;
                continue;
            }
            if (c == '\\') {
                if (index == s.length()) {
                    return index;
                }
                ++index;
                continue;
            }
            if (c == '(') {
                ++nest;
                continue;
            }
            if (c != '\r') continue;
            return --index;
        }
        return index;
    }

    private static boolean isSpace(char c) {
        if (c > '\u007f') {
            return false;
        }
        return (CHARMAP[c] & 4) != 0;
    }

    private static boolean isAtom(char c) {
        if (c > '\u007f') {
            return true;
        }
        if (c == ' ') {
            return false;
        }
        return (CHARMAP[c] & 3) == 0;
    }
}

