/*
 * Decompiled with CFR 0.152.
 */
package jp.wda.g2.system;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jp.wda.g2.SocketProcessor;
import jp.wda.g2.SocketReactor;
import jp.wda.g2.Socklet;
import jp.wda.g2.exception.AccessDeniedException;
import jp.wda.g2.exception.GPSSException;
import jp.wda.g2.system.SockletLinkage;

public class SockletContainer {
    private String name = null;
    private Socklet socklet = null;
    private SocketReactor mainReactor = null;
    private List<SocketProcessor> clients = Collections.synchronizedList(new ArrayList());

    public SockletContainer(String name, Socklet socklet) {
        this.name = name;
        this.socklet = socklet;
    }

    public String getName() {
        return this.name;
    }

    public Socklet getSocklet() {
        return this.socklet;
    }

    SocketReactor getMainReactor() {
        return this.mainReactor;
    }

    void setMainReactor(SocketReactor s) {
        this.mainReactor = s;
    }

    synchronized void accept(SocketProcessor client, SockletLinkage linkage) throws GPSSException {
        if (!this.socklet.checkConnection(client, linkage)) {
            throw new AccessDeniedException();
        }
        this.clients.add(client);
        this.mainReactor.notifyAcceptance(this, client);
    }

    synchronized void desert(SocketProcessor client, SockletLinkage linkage) {
        this.socklet.preRemoveClient(client, linkage);
        this.clients.remove(client);
        this.mainReactor.notifyDesertion(this, client);
    }

    public SocketProcessor[] getAllClients() {
        return this.clients.toArray(new SocketProcessor[0]);
    }

    Object doCommand(SocketProcessor client, ByteBuffer command, SockletLinkage linkage) throws GPSSException {
        return this.socklet.doCommand(client, command, linkage);
    }
}

