/*
 * Decompiled with CFR 0.152.
 */
package jp.wda.gpss.system;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import jp.wda.gpss.Socklet;

class SockletLoader
extends ClassLoader {
    private File classpath;

    SockletLoader(File classpath, ClassLoader parent) {
        super(parent);
        this.classpath = classpath;
    }

    Socklet loadSocklet(String className) throws ClassNotFoundException, IllegalArgumentException, IllegalAccessException, InstantiationException {
        return (Socklet)this.loadObject(className);
    }

    Object loadObject(String className) throws ClassNotFoundException, IllegalArgumentException, IllegalAccessException, InstantiationException {
        Class cls = this.findClass(className);
        if (cls != null) {
            return cls.newInstance();
        }
        throw new ClassNotFoundException(className);
    }

    public Class findClass(String className) throws ClassNotFoundException {
        Class<?> cls = this.findLoadedClass(className);
        if (cls != null) {
            return cls;
        }
        try {
            return this.defineClass(className);
        }
        catch (Throwable ex) {
            return this.getParent().loadClass(className);
        }
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        return this.loadClass(className, false);
    }

    protected Class loadClass(String className, boolean resolve) throws ClassNotFoundException {
        Class cls = this.findClass(className);
        if (resolve) {
            this.resolveClass(cls);
        }
        return cls;
    }

    Class defineClass(String className) throws IOException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException, InstantiationException {
        String classFilePath = String.valueOf(className.replace('.', File.separatorChar)) + ".class";
        File classFile = new File(this.classpath, classFilePath);
        if (!classFile.exists()) {
            return Class.forName(className);
        }
        byte[] bytes = this.getBytes(classFile);
        Class<?> cls = this.defineClass(className, bytes, 0, bytes.length);
        this.resolveClass(cls);
        return cls;
    }

    private byte[] getBytes(File file) throws IOException {
        byte[] bytes;
        block4: {
            FileInputStream fis = null;
            bytes = null;
            byte[] buf = new byte[20480];
            try {
                fis = new FileInputStream(file);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int n = 0;
                while ((n = fis.read(buf, 0, buf.length)) != -1) {
                    baos.write(buf, 0, n);
                }
                bytes = baos.toByteArray();
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (fis != null) {
                    fis.close();
                }
                throw throwable;
            }
            Object var7_9 = null;
            if (fis == null) break block4;
            fis.close();
        }
        return bytes;
    }
}

