/*
 * Decompiled with CFR 0.152.
 */
package jp.wda.gpss.system.seasar;

import java.io.File;
import jp.wda.gpss.system.Configuration;
import jp.wda.gpss.system.Main;
import jp.wda.gpss.system.SystemCommander;
import org.seasar.system.Lifecycle;
import org.seasar.util.SeasarException;

public final class GPSSService
implements Lifecycle {
    private Configuration configuration = null;
    private String _config = null;
    private String _gpss_home = null;

    public String getConfig() {
        return this._config;
    }

    public void setConfig(String s) throws SeasarException {
        File configfile = new File(s);
        if (!configfile.isAbsolute()) {
            configfile = new File(String.valueOf(System.getProperty("seasar.home")) + File.separator + s);
        }
        this._config = configfile.getAbsolutePath();
        this.configuration = new Configuration(configfile);
        try {
            this.configuration.loadConfig();
        }
        catch (Exception e) {
            throw new SeasarException("ESR001");
        }
    }

    public String getHome() {
        return this._gpss_home;
    }

    public void setHome(String s) {
        File home = new File(s);
        if (!home.isAbsolute()) {
            home = new File(new File(System.getProperty("seasar.home")), s);
        }
        this._gpss_home = home.getAbsolutePath();
        System.setProperty("gpss.home", this._gpss_home);
    }

    public void start() throws SeasarException {
        System.out.println("GPSS\u30b5\u30fc\u30d3\u30b9\u3092\u958b\u59cb\u3057\u307e\u3059\u3002");
        new GPSSStarter(this._config).start();
    }

    public void stop() throws SeasarException {
        SystemCommander.main(new String[]{"" + this.configuration.getPort(), "shutdown"});
    }

    private class GPSSStarter
    extends Thread {
        private String _config = null;

        GPSSStarter(String config) {
            this._config = config;
        }

        public final void run() {
            Main.main(new String[]{this._config});
        }
    }
}

