#!/bin/sh

# ------------- set GPSS Home --------------------------------------
# GPSS_HOME=""

# ------------- set GPSS Option ------------------------------------
GPSS_OPT=""
if [ "$GPSS_HOME" != "" ] ; then
    GPSS_OPT=-Dgpss.home="$GPSS_HOME"
fi

if [ -z "$JAVA_HOME" ] ;  then
  echo "You must set JAVA_HOME to point at your Java Development Kit installation"
  exit 1
fi

if [ -d ${JAVA_HOME}/jre ] ; then
  __SERVER_JVM_PATH=${JAVA_HOME}/jre/lib/i386/server
else
  __SERVER_JVM_PATH=${JAVA_HOME}/lib/i386/server
fi

if [ -d ${__SERVER_JVM_PATH} ] ; then
  GPSS_OPT="$GPSS_OPT -server"
  echo "Use Java HotSpot Server VM"
else
  echo "Use Java HotSpot Client VM"
fi

# ------------- set classpath --------------------------------------
GPSS_CP=$CLASSPATH

GPSS_CP=$GPSS_CP:./gpss.jar
GPSS_CP=$GPSS_CP:./classes/
GPSS_CP=$GPSS_CP:./lib/log4j-1.2.8.jar
GPSS_CP=$GPSS_CP:./lib/commons-beanutils.jar
GPSS_CP=$GPSS_CP:./lib/commons-collections.jar
GPSS_CP=$GPSS_CP:./lib/commons-digester.jar
GPSS_CP=$GPSS_CP:./lib/commons-logging.jar
GPSS_CP=$GPSS_CP:./lib/xmlParserAPIs.jar
GPSS_CP=$GPSS_CP:./lib/fesi.jar
GPSS_CP=$GPSS_CP:./lib/js.jar

GPSS_CP=$GPSS_CP:./lib/jdom.jar

${JAVA_HOME}/bin/java ${GPSS_OPT} -cp "${GPSS_CP}" jp.wda.gpss.system.Main config.xml
