/*
 * Decompiled with CFR 0.152.
 */
package FESI.Extensions;

import FESI.Data.ESBoolean;
import FESI.Data.ESLoader;
import FESI.Data.ESNull;
import FESI.Data.ESNumber;
import FESI.Data.ESObject;
import FESI.Data.ESUndefined;
import FESI.Data.ESValue;
import FESI.Exceptions.EcmaScriptException;
import FESI.Extensions.ESRowSet;
import FESI.Interpreter.Evaluator;
import FESI.Interpreter.LocalClassLoader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

class ESDatabase
extends ESObject {
    private transient Connection connection;
    private transient DatabaseMetaData databaseMetaData;
    private transient String driverName;
    private transient ClassLoader driverLoader;
    private transient Exception lastError;
    private transient ESObject esRowSetPrototype;
    private transient boolean driverOK = false;
    static /* synthetic */ Class class$java$sql$Driver;

    ESDatabase(ESObject eSObject, Evaluator evaluator, ESObject eSObject2, String string) {
        super(eSObject, evaluator);
        this.driverName = string;
        this.esRowSetPrototype = eSObject2;
        try {
            Class<?> clazz = Class.forName(string);
            if (!(class$java$sql$Driver != null ? class$java$sql$Driver : (class$java$sql$Driver = ESDatabase.class$("java.sql.Driver"))).isAssignableFrom(clazz)) {
                this.lastError = new EcmaScriptException("Class " + clazz + " is not a JDBC driver");
            }
            clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.lastError = classNotFoundException;
        }
        catch (InstantiationException instantiationException) {
            this.lastError = instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {}
        this.driverOK = true;
    }

    ESDatabase(ESObject eSObject, Evaluator evaluator, ESObject eSObject2, String string, String string2) {
        super(eSObject, evaluator);
        this.driverName = string;
        this.esRowSetPrototype = eSObject2;
        try {
            this.driverLoader = LocalClassLoader.makeLocalClassLoader(string2);
        }
        catch (EcmaScriptException ecmaScriptException) {
            this.lastError = ecmaScriptException;
            return;
        }
        try {
            Class<?> clazz = this.driverLoader.loadClass(string);
            if (!(class$java$sql$Driver != null ? class$java$sql$Driver : (class$java$sql$Driver = ESDatabase.class$("java.sql.Driver"))).isAssignableFrom(clazz)) {
                this.lastError = new EcmaScriptException("Class " + clazz + " is not a JDBC driver");
                return;
            }
            clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.lastError = classNotFoundException;
        }
        catch (InstantiationException instantiationException) {
            this.lastError = instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            this.lastError = illegalAccessException;
        }
        this.driverOK = true;
    }

    ESDatabase(ESObject eSObject, Evaluator evaluator) {
        super(eSObject, evaluator);
        this.driverName = null;
        this.esRowSetPrototype = null;
        this.driverOK = false;
    }

    public String getESClassName() {
        return "Database";
    }

    public String toString() {
        if (this.driverName == null) {
            return "[database protoype]";
        }
        return "[Database: '" + this.driverName + (this.driverOK ? (this.connection == null ? "' - disconnected] " : " - connected]") : " - in error]");
    }

    public String toDetailString() {
        return "ES:[Object: builtin " + this.getClass().getName() + ":" + this.toString() + "]";
    }

    ESValue getLastError() throws EcmaScriptException {
        if (this.lastError == null) {
            return ESNull.theNull;
        }
        return ESLoader.normalizeValue(this.lastError, this.evaluator);
    }

    ESValue connect(ESValue[] eSValueArray) throws EcmaScriptException {
        if (!this.driverOK) {
            throw new EcmaScriptException("Driver not initialized properly - cannot connect");
        }
        this.lastError = null;
        String string = eSValueArray.length > 0 ? eSValueArray[0].toString() : null;
        String string2 = eSValueArray.length > 1 ? eSValueArray[1].toString() : null;
        String string3 = eSValueArray.length > 2 ? eSValueArray[2].toString() : null;
        try {
            this.connection = string2 == null ? DriverManager.getConnection(string) : DriverManager.getConnection(string, string2, string3);
        }
        catch (Exception exception) {
            this.lastError = exception;
            return ESBoolean.makeBoolean(false);
        }
        return ESBoolean.makeBoolean(true);
    }

    ESValue disconnect() throws EcmaScriptException {
        if (!this.driverOK) {
            throw new EcmaScriptException("Driver not initialized properly - cannot disconnect");
        }
        this.lastError = null;
        if (this.connection != null) {
            try {
                this.connection.close();
                this.connection = null;
                this.lastError = null;
            }
            catch (SQLException sQLException) {
                this.lastError = sQLException;
                return ESBoolean.makeBoolean(false);
            }
        }
        return ESBoolean.makeBoolean(true);
    }

    ESValue release() {
        block2: {
            if (!this.driverOK) break block2;
            try {
                this.disconnect();
            }
            catch (EcmaScriptException ecmaScriptException) {}
        }
        return ESUndefined.theUndefined;
    }

    ESValue executeRetrieval(ESValue[] eSValueArray) throws EcmaScriptException {
        String string;
        String string2 = string = eSValueArray.length > 0 ? eSValueArray[0].toString() : null;
        if (this.connection == null) {
            throw new EcmaScriptException("JDBC driver not connected");
        }
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.connection.createStatement();
            resultSet = statement.executeQuery(string);
        }
        catch (SQLException sQLException) {
            this.lastError = sQLException;
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
            statement = null;
            return ESBoolean.makeBoolean(false);
        }
        ESRowSet eSRowSet = new ESRowSet(this.esRowSetPrototype, this.evaluator, string, this, statement, resultSet);
        return eSRowSet;
    }

    ESValue executeCommand(ESValue[] eSValueArray) throws EcmaScriptException {
        String string = eSValueArray.length > 0 ? eSValueArray[0].toString() : null;
        int n = 0;
        if (this.connection == null) {
            throw new EcmaScriptException("JDBC driver not connected");
        }
        Statement statement = null;
        try {
            statement = this.connection.createStatement();
            n = statement.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            this.lastError = sQLException;
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
            statement = null;
            return ESBoolean.makeBoolean(false);
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {}
        }
        return new ESNumber(n);
    }

    public Object getMetaData() {
        block2: {
            if (this.databaseMetaData != null) break block2;
            try {
                this.databaseMetaData = this.connection.getMetaData();
            }
            catch (SQLException sQLException) {}
        }
        return this.databaseMetaData;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

