#pragma optimize(on)

/*
GL_TEXTURE_RECTANGLE_NVgƂ
samplerRECT + texture2DRect
GL_TEXTURE_2DgƂ
sampler2D + texture2D
*/
//Currently, texture is not used in this shader.
//uniform samplerRECT	Texture0;
//uniform sampler2D	Texture1;
uniform vec3		CameraPos;
uniform vec3		CameraFrontDir;
uniform vec3		CameraUpDir;
uniform float		CameraNear;
uniform float		CameraFar;

uniform	int			NumLoop;

vec3	current_ray[2];
int		state = -1;

vec3	get_ray_pos(float t)
{
	return current_ray[1]*t + current_ray[0];
}

#if 0
const vec3 center = vec3(0.0, 0.0, 0.0);
/**
 *	This function represents shape where
 *	G(P) = 0
 *	P is point in xyz coordinate space.
 *
 *	G(P)
 *	G(Ray(t))
 *	= G(vt+p)
 *	= F(t)
 *	where v and p is constant value. v is direction of ray and p is position of ray.
 *
 */
float F(float t)
{
	const float radius = 150.0;

	const vec3 ray_pos = get_ray_pos(t);
	return	dot(ray_pos-center, ray_pos-center) - radius*radius;
	// F(t)=(vt+p-center)^2-radius^2
	// = dot(v,v)*t^2+2*dot(v, p-center))*t+dot(v, p-center)-radius^2
}

float deltaF(float t)
{
	const vec3 p = get_ray_pos(t);
	return
		2.0*dot(current_ray[1], current_ray[1])*t
		+
		2.0*dot(current_ray[1], current_ray[0]-center);
}
#else
/*
const float h=10.0;
const float s=0.0004;
float F(float t)
{
	const vec3 ray_pos = get_ray_pos(t);
	return	ray_pos.y - h*sin(s*dot(ray_pos.xz, ray_pos.xy));
}

float deltaF(float t)
{
	const vec3 ray_pos = get_ray_pos(t);
	return
		current_ray[1].y
		-
		h*cos(s*dot(ray_pos.xz, ray_pos.xy))
		*2.0*s*
		(ray_pos.x*current_ray[1].x+ray_pos.z*current_ray[1].z);
}
*/
const float a=0.005, b=-2.0;
float F(float t)
{
	vec3 ray_pos = get_ray_pos(t);

	return ray_pos.y - a*ray_pos.x*ray_pos.x - b;
}

float deltaF(float t)
{
	vec3 ray_pos = get_ray_pos(t);

	return current_ray[1].y - 2.0*a*ray_pos.x*current_ray[1].x;
}
#endif

vec4 lighting(vec3 position, vec3 normal)
{
/*
	vec3 fnormal = normalize(texture2D(Texture0, gl_TexCoord[0]).xyz);
	vec4 color = texture2D(Texture1, gl_TexCoord[0]);
	vec3 light = normalize(gl_LightSource[0].position.xyz - position);
	float diffuse = dot(light, fnormal);
*/
	//킵ǁAgl_LightSource[0].position͕š̌

	// Spot light from camera
	vec3 light_dir = normalize(position - CameraPos);
	float light_power = pow(max(dot(light_dir, CameraFrontDir), 0.0), 9.0);

	float diffuse = dot(-light_dir, normal);	
	vec4 ret_color = vec4(0.5, 0.43, 0.4, 1.0)*0.1;/*gl_LightSource[0].ambient;*/
	if (diffuse > 0.0)
	{
		vec3 reflected = reflect(light_dir, normal);
		float specular = pow(max(dot(reflected, -light_dir), 0.0), 2.0);//gl_FrontMaterial.shininess);
		ret_color += /*gl_LightSource[0].diffuse*/vec4(0.785, 0.416, 0.310, 1.0) * diffuse*0.25
				  + /*gl_FrontLightProduct[0].specular*/vec4(0.914, 0.804, 0.750, 1.0) * specular*/*0.1*/0.7*light_power;
	}

	return ret_color;
}

vec3 get_cross_point(out float t)
{
	t=CameraNear;

	// t must be larger than CameraNear.
	if(F(t)*deltaF(t) >=-0.01)
	{
		// t will decrease in Newton-Raphson method loop,
		// so avoid that by increase t.

		// move t to where deltaF(t) near== 0.
		const float epsilon = 0.01;
		float delta_t = deltaF(t);
		float ddelta = deltaF(t+epsilon) - delta_t;
		if(ddelta > -0.0001 && ddelta < 0.0001)
		{
			ddelta = deltaF(t+epsilon*100.0) - delta_t;
		}
		t += abs(delta_t / ddelta * epsilon);

		// increase t where abs(deltaF(t+e)-deltaF(t)) > e (e is small number)
		int i=0;
		float scaler = 1.2;
		float current_deltaF = abs(deltaF(t)), old_deltaF;
		while(current_deltaF <0.08 && i++<10/*NumLoop*/)
		{
			t += 10.0;//epsilon*scaler;
			old_deltaF = current_deltaF;
			current_deltaF = abs(deltaF(t));
			scaler += (0.01-(current_deltaF - old_deltaF))*2.0;
		}
		if(i<=10)
		{
			state=1;
		}else
		{
			state=0;
		}
	//	state=1;
	}

	//Newton-Raphson method.
	for(int i=0; i<NumLoop; ++i)
	{
		float f_t = F(t);
		//y-f_t=deltaF(t0)(t-t0);
		//When y==0
		t = t - f_t/deltaF(t);
	}

	return get_ray_pos(t);
}

vec3 get_normal(vec3 cross_pos)
{
	vec3 abs_v = abs(current_ray[1]);
	vec3 delta0, delta1;

	const float epsilon = 0.01;

	if(abs_v.x > abs_v.y && abs_v.x > abs_v.z)
	{
		delta0 = vec3(0.0, epsilon, 0.0);
		delta1 = vec3(0.0, 0.0, -sign(current_ray[1].x)*epsilon);
	}else if(abs_v.y > abs_v.z)
	{
		delta0 = vec3(0.0, 0.0, epsilon);
		delta1 = vec3(-sign(current_ray[1].y)*epsilon, 0.0, 0.0);
	}else
	{
		delta0 = vec3(epsilon, 0.0, 0.0);
		delta1 = vec3(0.0, -sign(current_ray[1].z)*epsilon, 0.0);
	}

	current_ray[1] = normalize(cross_pos+delta0-current_ray[0]);
	float t;
	vec3 cross_point0 = get_cross_point(t);

	current_ray[1] = normalize(cross_pos+delta1-current_ray[0]);
	vec3 cross_point1 = get_cross_point(t);

	vec3 diff0 = cross_point0 - cross_pos;
	vec3 diff1 = cross_point1 - cross_pos;

	return normalize(cross(diff0, diff1));
}

bool castRay(out vec3 cross_point, out vec3 cross_normal)
{
	float t;
	cross_point = get_cross_point(t);

	cross_normal = vec3(0.0, 0.0, -1.0);

	const float epsilon = 0.005;

	float f_t = F(t);
	if(f_t > -epsilon && f_t < epsilon)
	{
		cross_normal = get_normal(cross_point);
		return true;
	}else
	{
		return false;
	}
}

void main (void)
{
	vec3 camera_side_dir = normalize
	(
		cross(CameraFrontDir, CameraUpDir)
	) * gl_TexCoord[0].x;

	vec3 pos = CameraPos;
	vec3 dir = 
		normalize
		(
			CameraFrontDir*CameraNear
			+
			camera_side_dir
			+
			gl_TexCoord[0].y*CameraUpDir
		);
	vec3 ray[2] = vec3[2](pos, dir);

	vec3 cross_point, cross_normal;

	current_ray = ray;
	bool is_cross = castRay(cross_point, cross_normal);

	//Without tmp variable, GLSL compiler doesnt assing value to gl_FragDepth.
	float tmp_depth;
	vec4 tmp_color=vec4(0.5, 0.5, 0.5, 1.0);

	if(is_cross/* && dot(cross_normal, ray[1]) < 0.0*/)
	{
		float z = -dot(cross_point - CameraPos, CameraFrontDir);
		float A = 2.0*CameraNear*CameraFar/(CameraFar-CameraNear);
		float B = (CameraFar+CameraNear)/(CameraFar-CameraNear);
		tmp_depth = (A/z+B+1.0)/2.0;

		if(tmp_depth < 0.0)
		{
			tmp_color =
			state == 0 ? vec4(0.0, 0.0, 1.0, 1.0)
			:(
				state == 1 ? vec4(0.0, 1.0, 0.0, 1.0)
				:(
					vec4(1.0, 0.0, 0.0, 1.0)
				)
			);

			tmp_depth = 0.0;
		}else
		{
			if(tmp_depth > 1.0)
			{
				tmp_depth = 1.0;
				if(state == 1)
				{
					tmp_color = vec4(1.0, 0.0, 0.0, 1.0);
				}else
				{
					tmp_color = vec4(1.0, 1.0, 1.0, 1.0);
				}
			}else
			{
				tmp_color = lighting(cross_point, cross_normal);
			}
		}
	//	tmp_depth = 0.0;
	//	tmp_color = vec4(1.0, 1.0, 1.0, 1.0);
	}else
	{
		tmp_depth= 1.0;
		tmp_color = vec4(0.7, 0.7, 0.0, 1.0);
	}

	gl_FragDepth = tmp_depth;
	gl_FragColor = tmp_color;
}

