
/*
GL_TEXTURE_RECTANGLE_NVgƂ
samplerRECT + texture2DRect
GL_TEXTURE_2DgƂ
sampler2D + texture2D
*/
//uniform samplerRECT	Texture0;
//uniform sampler2D	Texture1;
uniform vec3		CameraPos;
uniform vec3		CameraFrontDir;
uniform vec3		CameraUpDir;
uniform float		CameraNear;
uniform float		CameraFar;

uniform	float		AnimCounter;
uniform int			NumLoop;
uniform mat4		ModelMatrixInv;

bool isInner
(
	vec2 p,
	vec2 ve,
	vec2 vf
)
{
	vec2 vn = vec2(-ve.y, ve.x);

	return dot(vn, vf)*dot(vn, p) >= 0.0;
}

bool isInTriangle(
			vec2 p,
			vec2 v0, vec2 v1, vec2 v2)
{
	return isInner(p-v0, v1-v0, v2-v0) &&
	       isInner(p-v1, v2-v1, v0-v1) &&
	       isInner(p-v2, v0-v2, v1-v2);
}

// triangle͎Op`3_̍W
// ray͌Bray[0]n_ray[1]
// Ԃľ^boolƃ_
bool isCrossTriangle(vec3 triangle[3], vec3 ray[2], out vec3 cross_point, out vec3 cross_normal)
{
	cross_normal = normalize(cross(triangle[1] - triangle[0], triangle[2] - triangle[0]));
	float D = dot(cross_normal, ray[1]);
	float E = dot(cross_normal, triangle[0] - ray[0]);
	bool ret = false;

	if(D < 0.0 && E <= 0.0)
	{
		cross_point = ray[0] + ray[1] * E/D;

		vec3 abs_normal = abs(cross_normal);

		if(abs_normal.x > abs_normal.y
		&& abs_normal.x > abs_normal.z)
		{
			ret = isInTriangle(cross_point.yz, triangle[0].yz, triangle[1].yz, triangle[2].yz);
		}else if(abs_normal.y > abs_normal.z)
		{
			ret = isInTriangle(cross_point.zx, triangle[0].zx, triangle[1].zx, triangle[2].zx);
		}else
		{
			ret = isInTriangle(cross_point.xy, triangle[0].xy, triangle[1].xy, triangle[2].xy);
		}
	}

	return ret;
}

vec4 virtual_tex(vec2 uv)
{
	return vec4
	(
		(sin(uv.x*18.0)+cos(uv.y*18.0))/4.0+0.5,
		uv.y,
		sin(uv.x*20.0)/2.0+0.5,
		1.0
	);
}

int get_region_index(vec3 position)
{
	return int(mod(floor(position.x), 2.0))*2+int(mod(floor(position.z),2.0));
}

vec4 lighting(vec3 position, vec3 normal)
{
	// Spot light from camera
	vec3 light_dir = normalize(position - CameraPos);
	float light_power = pow(max(dot(light_dir, CameraFrontDir), 0.0), 9.0);

	vec4 color_table[4];
	color_table[0] = vec4(1.0, 0.0, 0.0, 1.0);
	color_table[1] = vec4(0.0, 0.0, 1.0, 1.0);
	color_table[2] = vec4(1.0, 1.0, 0.0, 1.0);
	color_table[3] = vec4(1.0, 1.0, 1.0, 1.0);

	float diffuse = dot(-light_dir, normal);	
	vec4 ret_color = vec4(0.6, 0.3, 0.1, 1.0)*0.1;/*gl_LightSource[0].ambient;*/
	if (diffuse > 0.0)
	{
		vec3 reflected = reflect(light_dir, normal);
		float specular = pow(max(dot(reflected, -light_dir), 0.0), 2.0);//gl_FrontMaterial.shininess);

		int id = get_region_index(position);
		ret_color.xyz += /*color_table[id]*/vec3(1.0, 1.0, 0.0) * diffuse*0.3
				  + /*color_table[id]*/vec3(0.0, 1.0, 1.0) * specular*/*0.1*/0.7*light_power;
	}

	return
		ret_color*0.6
		+
		virtual_tex
		(
			vec2
			(
				normal.x/2.0+0.5,
				normal.y/2.0+0.5
			)
		)*0.4;
}

float sinu(float x)
{
	return (sin(x*1.5+AnimCounter)+sin(x/2.0)+sin(x/5.0))/3.0;
}

bool getNextRayOrigin(inout vec3 ray0, vec3 ray1)
{
	const float delta = 0.0017;	//This delta value is used for a small moving ray0 in direction of ray1.
	vec3 local_ray_origin = vec3(fract(ray0.xz), ray0.y).xzy;

	//ʂƌ?
	vec3 cross_point = local_ray_origin + ray1*(-local_ray_origin.y/ray1.y);
	if(cross_point.x < 1.0 && cross_point.x > 0.0 && cross_point.z < 1.0 && cross_point.z > 0.0)
	{
		//ʂƌ
	//	cross_point = vec3(cross_point.xz, 0.0).xzy;
		return true;
	}else
	{
		if(ray1.x > 0.0)
		{
			// Eʂƌ?
			cross_point = local_ray_origin + ray1*((1.0-local_ray_origin.x)/ray1.x);
			if(cross_point.z >= 1.0 || cross_point.z <= 0.0)
			{
				if(ray1.z < 0.0)
				{
					// Oʂƌ
					cross_point = local_ray_origin + ray1*((-local_ray_origin.z)/ray1.z);
				}else
				{
					// ʂƌ
					cross_point = local_ray_origin + ray1*((1.0-local_ray_origin.z)/ray1.z);
				}
			}
		}else
		{
			// ʂƌ?
			cross_point = local_ray_origin + ray1*(-local_ray_origin.x/ray1.x);
			if(cross_point.z >= 1.0 || cross_point.z <= 0.0)
			{
				if(ray1.z < 0.0)
				{
					// Oʂƌ
					cross_point = local_ray_origin + ray1*((-local_ray_origin.z)/ray1.z);
				}else
				{
					// ʂƌ
					cross_point = local_ray_origin + ray1*((1.0-local_ray_origin.z)/ray1.z);
				}
			}
		}
	
		ray0 = vec3(cross_point.xz+floor(ray0.xz), cross_point.y).xzy + ray1*delta;	
		return false;
	}
}

void isNearestTriangle(vec3 triangle[3], inout float nearest, vec3 ray[2], inout vec3 cross_point, inout vec3 cross_normal)
{
	vec3 pos, normal;

	if(isCrossTriangle(triangle, ray, pos, normal))
	{
		float dist = distance(ray[0], pos);
		if(dist < nearest || nearest < 0.0)
		{
			nearest = dist;
			cross_point = pos;
			cross_normal = normal;
		}
	}
}

bool isCrossSphere(vec3 ray[2], out vec3 cross_point, out vec3 cross_normal, float y)
{
	vec3 center = vec3(0.5, y, 0.5);
	float rad = 0.5-(y-0.5)*0.2;

	vec3 moved = ray[0] - center;
	float a = dot(ray[1], ray[1]);
	float b = 2.0*dot(moved, ray[1]);
	float c = dot(moved, moved) - rad*rad;
	float d2 = b*b - 4.0*a*c;

	bool ret;
	if(d2 <= 0.0)
	{
		ret = false;
	}else
	{
		float t = (-b-sqrt(d2))/(2.0*a);
		if(t <= 0.0)
		{
			ret = false;
		}else
		{
			cross_point = ray[0] + t*ray[1];
			cross_normal = normalize(cross_point - center);
			ret = true;
		}
	}

	return ret;
}

bool castRayInblock(vec3 ray[2], out vec3 cross_point, out vec3 cross_normal)
{
	vec3 local_ray[2];

	local_ray[0] = vec3(fract(ray[0]).xz, ray[0].y).xzy; // blockł̃[JW
	local_ray[1] = ray[1];

	vec3 local_pos;
	bool ret = /*isCrossObject*/isCrossSphere
	(
		local_ray, local_pos, cross_normal,
		(sinu(floor(ray[0].x))+sinu(floor(ray[0].z)))/2.0+1.5
	);

	if(ret)
	{
		cross_point.xz = local_pos.xz + floor(ray[0].xz);
		cross_point.y = local_pos.y;
	}

	return ret;
}

bool castRay(vec3 ray[2], out vec3 cross_point, out vec3 cross_normal)
{
	const float upper = 3.0, bottom = 0.0;

	if((ray[0].y >= upper && ray[1].y >= 0.0)
	||  (ray[0].y <= bottom && ray[1].y <= 0.0))
	{
		return false;
	}else
	{
		vec3 new_ray_pos;
		if(ray[0].y >= upper)
		{
			new_ray_pos = ray[0] + ray[1]*((upper-ray[0].y)/ray[1].y);
		}else
		{
			new_ray_pos = ray[0];
		}

		bool ret;
		int count = 0;
		bool is_bottom;

		do
		{
			vec3 tmp_ray[2];
			tmp_ray[0] = new_ray_pos;
			tmp_ray[1] = ray[1];

			ret=castRayInblock(tmp_ray, cross_point, cross_normal);
			is_bottom =	getNextRayOrigin(new_ray_pos, ray[1]);

			count++;
		}while
		(
			!(
				ret
				|| is_bottom
				|| count > NumLoop
			)
		);

		return ret;
	}
}

vec4 lighting_with_ref(vec3 position, vec3 normal)
{
	const float delta = 0.0005;

	vec3 ray[2];

	int id = get_region_index(position);
	if(id<2)
	{
		ray[1] = refract(CameraFrontDir, normal, 0.5);
	}else
	{
		ray[1] = reflect(CameraFrontDir, normal);
	}
	ray[0] = position + ray[1]*delta;

	vec3 cross_point, cross_normal;
	if(castRay(ray, cross_point, cross_normal))
	{
		return lighting(cross_point, cross_normal);
	}else
	{
		return lighting(position, normal);
	}
}

void main (void)
{
	vec3 camera_side_dir = normalize
	(
		cross(CameraFrontDir, CameraUpDir)
	) * (gl_TexCoord[0].x*2.0-1.0);

	vec3 ray[2];

	ray[0] = (ModelMatrixInv*vec4(CameraPos, 1.0)).xyz;
	ray[1] =
	(
		ModelMatrixInv
		*
		vec4
		(
			normalize
			(
				CameraFrontDir*CameraNear
				+
				camera_side_dir
				+
				(gl_TexCoord[0].y*2.0-1.0)*CameraUpDir
			),
			0.0
		)
	).xyz;

	vec3 cross_point, cross_normal;

	bool is_cross = castRay(ray, cross_point, cross_normal);

	//Without tmp variable, GLSL compiler doesnt assing value to gl_FragDepth.
	float tmp_depth;
	vec4 tmp_color;

	if(is_cross && dot(cross_normal, ray[1]) < 0.0)
	{
		float z = -dot(cross_point - CameraPos, CameraFrontDir);
		float A = 2.0*CameraNear*CameraFar/(CameraFar-CameraNear);
		float B = (CameraFar+CameraNear)/(CameraFar-CameraNear);
		//nvidia depth
	//	tmp_depth = (A/z+B+1.0)/2.0;
		//ati depth, but it seems that this works in nvidia...
		tmp_depth =
		clamp
		(
			1.00425*(A/z+B+1.0)/2.0,
			0.0,
			1.0	
		);

		tmp_color = lighting_with_ref/*lighting*/(cross_point, cross_normal);
	}else
	{
		tmp_depth= 1.0;
		tmp_color = vec4(0.0, 0.0, 0.0, 1.0);
	}

	gl_FragDepth = tmp_depth;
	gl_FragColor = tmp_color;
}

