#ifndef GL_HANDLER_HPP
#define GL_HANDLER_HPP

//#include "../stdafx.h"
#include "handler.hpp"
#include "../triangle_buffer.hpp"
#include <gpuppur/mesh/rectangle_opengl.hpp>

//template<typename DontUseThisSymbol=boost::mpl::void_>
class gl_handler : public handler_base
{
public:

	typedef gl_handler//<DontUseThisSymbol>
								this_type;
	typedef gpuppur::gglut		gpuppurut_type;
	typedef gpuppur::GLSL		ShaderClass;
	typedef handler_base		base;

	void set_gpuppurut();

	gl_handler():
		displaylist(0),
		sphere_rendering_mode(Raytracing),
		is_render_cube(true)
	{
		this->set_gpuppurut();
	}

	gpuppurut_type& get_gpuppurut()
	{
		return this->my_gut;
	}

	boost::mpl::void_ get_context()
	{
		return boost::mpl::void_();
	}

protected:

	void uninit(gpuppur::gpuppurut&);
	bool init(gpuppur::gpuppurut&);
	void draw(gpuppur::gpuppurut& gut);
	void resize(gpuppur::gpuppurut& gut, int width, int height);
	void keyboard_up(gpuppur::gpuppurut& /*gut*/, int key, int /*x*/, int /*y*/);

//	typedef gpuppur::Cg		ShaderClass;

	gpuppur::rectangle_opengl			rectangle;

	TriangleBuffer
	<
		gpuppur::texbuf<vector3, gpuppur::gl_texbuf>
	>									triangle_buffer;

	TriangleBuffer
	<
		gpuppur::texbuf<gpuppur::VectorNd<float, 4>, gpuppur::gl_texbuf>
	//	gpuppur::texbuf<gpuppur::VectorNd<float, 4>, gpuppur::gl_pbo_buf>
	>									texture;

	GLuint								displaylist;

private:
	typedef handler<this_type>	tmpler;

	void uninit_render_sphere_resource();
	void create_displaylist();
	void create_small_displaylist();
	void create_mesh(bool is_big=false);

	const static std::size_t	sphere_depth	= 70;
	const static std::size_t	sphere_width	= 10;
	const static std::size_t	num_div_theta	= 16;
	const static std::size_t	num_div_phi		= 8;

	enum rendering_mode
	{
		Raytracing,
		SmallMemory,
		Displaylist,
		VertexBuffer,
		BigVertexBuffer
	}	sphere_rendering_mode;

	tmpler						common_handler;

	bool						is_render_cube;
	gpuppur::mesh_opengl		mesh;

	gpuppurut_type				my_gut;

	friend class tmpler;
};

#endif

