#include "stdafx.h"
#include "handler.hpp"

using namespace gpuppur;
using namespace boost;

void gen_sphere_vertex
(
	std::vector<vector3>&	vertices,
	std::vector<vector3>&	normals,
	const int				num_div_theta,
	const int				num_div_phi,
	const vector3			position
)
{
	struct inr
	{
		static vector3 get_vertex(float theta, float phi, float r)
		{
			vector3 ret;

			float cos_phi	= static_cast<float>(cos(phi));
			float cos_theta = static_cast<float>(cos(theta)); 
			float sin_phi	= static_cast<float>(sin(phi));
			float sin_theta	= static_cast<float>(sin(theta));

			ret[0] = r*cos_phi*cos_theta;
			ret[1] = r*sin_phi;
			ret[2] = r*cos_phi*sin_theta;

			return ret;
		}
	};

	vector3	vertex;
	const static float	radius(0.5f);
	const vector3		center_pos=vector3(0.5f, 0.5f, 0.5f)+position;

	vertex = vector3(0.0f, radius, 0.0f);
	vertices.push_back(vertex+center_pos);
	normals.push_back(vertex.getNormalized());
	float delta_phi = static_cast<float>(M_PI/num_div_phi);
	float phi	= static_cast<float>(M_PI/2.0-delta_phi);
	float theta = 0.0f;
	float delta_theta = static_cast<float>(2.0*M_PI/num_div_theta);
	for(int i=1; i<num_div_phi; ++i, phi-=delta_phi)
	for(int j=0; j<num_div_theta; ++j, theta+=delta_theta)
	{
		vertex = inr::get_vertex(theta, phi, radius);
		vertices.push_back(vertex+center_pos);
		normals.push_back(vertex.getNormalized());
	}

	vertex = vector3(0.0f, -radius, 0.0f);
	vertices.push_back(vertex+center_pos);
	normals.push_back(vertex.getNormalized());
}

const float handler_base::near_plane = 2.0f;

handler_base::handler_base():
	has_error(false), camera(0.0f, 10.0f, 10.0f),
	num_loop(16), anim_counter(0.0f),
	is_pressing_right(false), mouse_val(1.0f, 1.0f)
{
}

handler_base::~handler_base()
{
}

void handler_base::keyboard(gpuppurut& gut, int key, int /*x*/, int /*y*/)
{
	this->camera.keyboard(key);

	switch(key)
	{

	case ' ':
	{
		vector3 vel = this->camera.get_front()*40.3f;
		this->phys.create_cube(this->camera.get_pos(), vel);
		break;
	}

	case '\033':	//esc key
	//	exit(0);
		gut.uninitialize();
		break;

	case gpuppurut::LEFT:
//		rot_y += rot_speed;
		break;

	case gpuppurut::RIGHT:
//		rot_y -= rot_speed;
		break;

	case gpuppurut::UP:
//		rot_x += rot_speed;
		break;

	case gpuppurut::DOWN:
//		rot_x -= rot_speed;
		break;
	}
}

void handler_base::keyboard_up(gpuppur::gpuppurut& /*gut*/, int key, int /*x*/, int /*y*/)
{
	this->camera.keyboard_up(key);
}

void handler_base::motion(gpuppurut&, int button, int state, int x, int y)
{
	if(button == gpuppurut::MOUSE_LEFT && state == gpuppurut::KEY_DOWN)
	{
		this->camera.begin_moving(x, y);
	}
	else if(button == gpuppurut::MOUSE_LEFT && state == gpuppurut::KEY_UP)
	{
		this->camera.end_moving();
	}

	if(button == gpuppurut::MOUSE_RIGHT && state == gpuppurut::KEY_DOWN)
	{
		this->begin_mouse_pos = vector2i(x, y);
		this->begin_mouse_val = this->mouse_val;
		this->is_pressing_right = true;
	}
	else if(button == gpuppurut::MOUSE_RIGHT && state == gpuppurut::KEY_UP)
	{
		this->is_pressing_right = false;
	}

	if(this->is_pressing_right)
	{
			this->mouse_val
		=
					vector2i(x, y)
				-
					this->begin_mouse_pos
			+
				this->begin_mouse_val;
	}

	this->camera.move_mouse(x, y);
}
