#ifndef HANDLER_HPP
#define HANDLER_HPP

#include "../nxphysics.hpp"

void gen_sphere_vertex
(
	std::vector<vector3>&	vertices,
	std::vector<vector3>&	normals,
	const int				num_div_theta,
	const int				num_div_phi,
	const vector3			position=vector3(0.0f, 0.0f, 0.0f)
);

class handler_base
{
public:

	handler_base();
	virtual ~handler_base();

	bool get_has_error() const
	{
		return has_error;
	}

	bool find_error()
	{
		return !(this->has_error = true);
	}

protected:

//	virtual void resize(gpuppur::gpuppurut& gut, int width, int height) = 0;
	void keyboard(gpuppur::gpuppurut& gut, int key, int x, int y);
	void keyboard_up(gpuppur::gpuppurut& /*gut*/, int key, int /*x*/, int /*y*/);

	void motion(gpuppur::gpuppurut& gut, int, int, int x, int y);

	gpuppur::camera		camera;
	physics				phys;
	const static float	near_plane;
	int					num_loop;

	float				anim_counter;

	bool				is_pressing_right;
	vector2i			begin_mouse_pos;
	vector2				begin_mouse_val;
	vector2				mouse_val;

private:

	bool				has_error;
};

template<class Parent>
class handler
{
public:

	typedef Parent							parent;
	typedef typename parent::ShaderClass	shader_class;
	typedef typename parent::ShaderClass::uniform_handle
											uniform_handle;

//	void set_gpuppurut(gpuppur::gpuppurut& gut);

	template<class Derived>
	void tmpl_uninit(Derived& that)
	{
		that.rectangle.uninitialize();
		this->programmable_shader.uninitialize();
		this->fix_shader.uninitialize();
	}

	template<class Derived>
	bool tmpl_init(gpuppur::gpuppurut& gut, Derived& that)
	{
		if(!that.phys.initialize())
		{
			std::cerr << "Failed to initialize physics." << std::endl;
			return false;
		}

		that.camera.set_speed(0.1f);

#if 1

		if(!that.rectangle.initialize(that.get_context()))
		{
			std::cerr << "Failed to initialize rectangle." << std::endl;
			return false;
		}

		if(!that.triangle_buffer.initialize(3, 10, 0))	//2Ԗڂ͎̈Op`̐
		{
			std::cerr << "Failed to initialize triangle buffer." << std::endl;
			return false;
		}

		vector3 triangles[10][3] =
		{
			{vector3(0.25f, 1.0f, 0.5f), vector3(0.0f, 0.0f, 0.5f), vector3(0.35f, 0.0f, 1.0f)},
			{vector3(0.25f, 1.0f, 0.5f), vector3(0.35f, 0.0f, 1.0f), vector3(0.4f, 0.9f, 1.0f)},
			{vector3(0.4f, 0.9f, 1.0f), vector3(0.35f, 0.0f, 1.0f), vector3(0.65f, 0.0f, 1.0f)},
			{vector3(0.4f, 0.9f, 1.0f), vector3(0.65f, 0.0f, 1.0f), vector3(0.6f, 1.0f, 1.0f)},
			{vector3(0.6f, 1.0f, 1.0f), vector3(0.65f, 0.0f, 1.0f), vector3(1.0f, 0.0f, 0.5f)},
			{vector3(0.6f, 1.0f, 1.0f), vector3(1.0f, 0.0f, 0.5f), vector3(0.25f, 1.0f, 0.5f)},
			{vector3(0.25f, 1.0f, 0.5f), vector3(1.0f, 0.0f, 0.5f), vector3(0.5f, 0.0f, 0.0f)},
			{vector3(0.25f, 1.0f, 0.5f), vector3(0.5f, 0.0f, 0.0f), vector3(0.5f, 1.0f, 0.2f)},
			{vector3(0.5f, 1.0f, 0.2f), vector3(0.5f, 0.0f, 0.0f), vector3(0.0f, 0.0f, 0.5f)},
			{vector3(0.5f, 1.0f, 0.2f), vector3(0.0f, 0.0f, 0.5f), vector3(0.25f, 1.0f, 0.5f)}
		};

		if(!that.triangle_buffer.lock_for_write())
		{
			return false;
		}

	//	int index = 0;
		for(int i=0; i<10; i++)
		{
			for(int j=0; j<3; j++)
			{
			//	that.triangle_buffer.set(/*index++, */triangles[i][j]);
				that.triangle_buffer.set(triangles[i][j]);
			}
		}
		that.triangle_buffer.unlock();

		that.triangle_buffer.activate(boost::mpl::void_());

		if
		(
			!this->programmable_shader.initialize
			(
				"../data/vert_shader",
				"../data/frag_shader",
				boost::mpl::void_()
			)
		)
		{
			std::cerr << "Failed to initialize programmable_shader." << std::endl;
			return false;
		}

		this->programmable_shader.bind_shader();

		this->location_camera_pos
		= this->programmable_shader.get_uniform_handle("CameraPos");

		this->location_camera_front_dir
		= this->programmable_shader.get_uniform_handle("CameraFrontDir");

		this->location_camera_up_dir
		= this->programmable_shader.get_uniform_handle("CameraUpDir");

		this->location_camera_near
		= this->programmable_shader.get_uniform_handle("CameraNear");

		this->location_camera_far
		= this->programmable_shader.get_uniform_handle("CameraFar");

//		this->programmable_shader.set_uniform_texture("Texture0", this->triangle_buffer);
		this->location_num_loop
		= this->programmable_shader.get_uniform_handle("NumLoop");
		this->programmable_shader.set_uniform
		(
			this->location_num_loop,
			that.num_loop
		);

		this->location_anim_counter
		= this->programmable_shader.get_uniform_handle("AnimCounter");
		if(!this->location_anim_counter)
		{
			std::cerr << "No(or omitted unused value) uniform value \"AnimCounter\"" << std::endl;
			return false;
		}

		this->location_model_matrix_inv
		= this->programmable_shader.get_uniform_handle("ModelMatrixInv");

#endif
		if
		(
			!this->fix_shader.initialize
			(
				"../data/fix_vert_shader", "../data/fix_frag_shader",
				boost::mpl::void_()
			)
		)
		{
			std::cerr << "Failed to initialize fix_shader." << std::endl;
			return false;
		}

		if(!that.texture.initialize(32, 32, 0))
		{
			std::cerr << "Failed to initialize texture." << std::endl;
			return false;
		}

		if(!that.texture.lock_for_write())
		{
			return false;
		}

		size_t w = that.texture.get_width();
		size_t h = that.texture.get_height();
		const size_t bnd = 1;
		for(size_t i = 0; i<h; ++i)
		for(size_t j = 0; j<w; ++j)
		{
			if(i>=0 && i<=bnd)
				that.texture.set(gpuppur::VectorNd<float, 4>(1.0f, 0.0f, 0.0f, 1.0f));
			else if(i>=w-1-bnd && i<w)
				that.texture.set(gpuppur::VectorNd<float, 4>(0.0f, 0.0f, 1.0f, 1.0f));
			else if(j>=0 && j<=bnd)
				that.texture.set(gpuppur::VectorNd<float, 4>(1.0f, 1.0f, 1.0f, 1.0f));
			else if(j>=h-1-bnd && j<h)
				that.texture.set(gpuppur::VectorNd<float, 4>(1.0f, 1.0f, 1.0f, 0.0f));
			else
				that.texture.set(gpuppur::VectorNd<float, 4>(1.0f, 1.0f, 1.0f, 0.5f));
		}

		that.texture.unlock();

		return true;
	}

	template<class Derived>
	void tmpl_draw(gpuppur::gpuppurut& /*gut*/, Derived& that)
	{
		that.camera.process();
#if 1
		if(that.sphere_rendering_mode == Derived::Raytracing)
		{
			this->programmable_shader.bind_shader();

			this->programmable_shader.set_uniform
			(
				this->location_camera_pos,		&that.camera.get_pos()[0]
			);
			this->programmable_shader.set_uniform
			(
				this->location_camera_front_dir,	&that.camera.get_front()[0]
			);
			this->programmable_shader.set_uniform
			(
				this->location_camera_up_dir,	&that.camera.get_up()[0]
			);
			this->programmable_shader.set_uniform
			(
				this->location_camera_near,		Derived::near_plane
			);
			this->programmable_shader.set_uniform
			(
				this->location_camera_far,		560.0f
			);

			this->programmable_shader.set_uniform
			(
				this->location_anim_counter,
				that.anim_counter
			);

			matrix4x4 mat;
			mat.load_unit_matrix();
			mat(0, 0) = that.mouse_val[0]/20.0f+(19.0f/20.0f);
			gpuppur::rotate_2vectors
			(
				mat.column(2), mat.column(1),
				that.mouse_val[1]/90.0f
			);

			this->programmable_shader.set_uniform
			(
				this->location_model_matrix_inv,
				gpuppur::get_inversed(mat)
			);

			that.rectangle.set_state(that.get_context());
			that.rectangle.draw(that.get_context());
		}
#endif

		that.anim_counter += 0.05f;
		if(that.anim_counter > M_PI*2.0)
		{
			that.anim_counter -= M_PI*2.0;
		}
	}

	template<class Derived>
	void tmpl_keyboard_up(gpuppur::gpuppurut& gut, Derived& that, int key, int x, int y)
	{
		switch(key)
		{
		case '[':
			that.num_loop++;
			goto set_num_loop;
			break;

		case ']':
			that.num_loop--;
		set_num_loop:
			this->programmable_shader.bind_shader();
			this->programmable_shader.set_uniform
			(
				this->location_num_loop,
				that.num_loop
			);
			std::cout << "num_loop=" << that.num_loop << std::endl;
			break;
		}
	}
	
	template<class Derived>
	static void tmpl_set_gpuppurut(gpuppur::gpuppurut& gut, Derived* that)
	{
		gut.setUninit3DContextFunc(boost::bind(&Derived::uninit, that, _1));
		gut.setInit3DContextFunc(boost::bind(&Derived::init, that, _1));
		gut.setRedrawFunc(boost::bind(&Derived::draw, that, _1));
		gut.setResizeFunc(boost::bind(&Derived::resize, that, _1, _2, _3));
		gut.setKeyPressingFunc(boost::bind(&Derived::keyboard, that, _1, _2, _3, _4));
		gut.setKeyUpFunc(boost::bind(&Derived::keyboard_up, that, _1, _2, _3, _4));
		gut.setMouseFunc(boost::bind(&Derived::motion, that, _1, _2, _3, _4, _5));
	}

	shader_class							programmable_shader;
	uniform_handle							location_camera_pos;
	uniform_handle							location_camera_front_dir;
	uniform_handle							location_camera_up_dir;
	uniform_handle							location_camera_near;
	uniform_handle							location_camera_far;
	uniform_handle							location_num_loop;
	uniform_handle							location_anim_counter;
	uniform_handle							location_model_matrix_inv;

	shader_class								fix_shader;
};

#endif

