#include "stdafx.h"
#include "nxphysics.hpp"
#include "timer.hpp"
#include "handler/gl_handler.hpp"

using namespace gpuppur;

int _tmain(int argc, _TCHAR* argv[])
{
	setlocale(LC_ALL, "");
	gglut::global_initialize(&argc, argv);

	gl_handler handler;
//	gglut gut;

//del	handler.set_gpuppurut(gut);

	if(handler.get_gpuppurut().initialize(512, 512, std::wstring(L"GPU Ray Tracer with OpenGL")) != gpuppurut::ReturnCode::OK)
	{
		fprintf(stderr, "Failed to initialize gpuppurut.\n");
		::getchar();
		return 0;
	}

	if(handler.get_has_error())
	{
		fprintf(stderr, "Failed to initialize 3d context.\n");
		::getchar();
		return 0;
	}

	while(!handler.get_gpuppurut().get_is_closed())
	{
		if(handler.get_gpuppurut().get_is_visible() != gpuppurut::ReturnCode::Visible)
		{
			continue;
		}

		gpuppur::frame_per_second::probe();

		handler.get_gpuppurut().redraw();

		gglut::handle_event();
	}

	return 0;
}
