#ifndef NXPHYSICS_HPP
#define NXPHYSICS_HPP

#define SAFE_RELEASE(p) if(p!=NULL){p->release();p=NULL;}
#define SAFE_DELETE(p) if(p!=NULL){delete p;p=NULL;}

class physics
{
protected:
	NxPhysicsSDK*			physics_sdk;
	NxScene*				scene;
	std::vector<NxActor*>	actors;

public:
	physics();
	~physics();

	void uninitialize();
	bool initialize();
	void process();
	void create_cube(const vector3& pos, const vector3& initial_velocity);
};

#endif

