#ifndef STDAFX_H
#define STDAFX_H

#include <gpuppur/utility/begin_suppress_warnings_from_others_code.hpp>

#define WIN32_LEAN_AND_MEAN
#define NOMINMAX
#include <tchar.h>

#include <cmath>
#include <cstdio>
#include <cstdlib>
#include <cassert>

#include <iostream>
#include <fstream>
#include <string>
#include <vector>

#include <boost/bind.hpp>
#include <boost/date_time/posix_time/posix_time.hpp>

#include <NxVec3.h>
#include <NxPhysicsSDK.h>
#include <NxRay.h>
#include <PhysXLoader.h>
#include <NxSceneDesc.h>
#include <NxMaterial.h>
#include <NxScene.h>
#include <NxPlaneShapeDesc.h>
#include <NxActorDesc.h>
#include <NxBoxShapeDesc.h>
#include <NxActor.h>

#include <GL/glew.h>
//#include <half.h>	// part of the openEXR

#include <gpuppur/utility/end_suppress_warnings.hpp>

//Following files are written by me. So print all warnings.
#include <gpuppur/gpuppurut/gglut.hpp>
#include <gpuppur/3dmath/vectorNd.hpp>
#include <gpuppur/3dmath/matrixRxC.hpp>
#include <gpuppur/utility/frame_per_second.hpp>

typedef gpuppur::VectorNd<float, 2>	vector2;
typedef gpuppur::VectorNd<float, 3>	vector3;
typedef gpuppur::VectorNd<float, 4>	vector4;
typedef gpuppur::VectorNd<int, 2>	vector2i;
typedef gpuppur::matrixRxC<float, 4, 4, false> matrix4x4;

#include <gpuppur/error_manage/error_report_gl.hpp>
#include <gpuppur/shader/glsl.hpp>
//#include <gpuppur/shader/Cg.hpp>
#include <gpuppur/gpuppurut/camera.hpp>
#include <gpuppur/texbuf/gl_tex_buf.hpp>
#include <gpuppur/mesh/mesh_opengl.hpp>

#ifndef M_PI

#define M_E        2.71828182845904523536
#define M_LOG2E    1.44269504088896340736
#define M_LOG10E   0.434294481903251827651
#define M_LN2      0.693147180559945309417
#define M_LN10     2.30258509299404568402
#define M_PI       3.14159265358979323846
#define M_PI_2     1.57079632679489661923
#define M_PI_4     0.785398163397448309616
#define M_1_PI     0.318309886183790671538
#define M_2_PI     0.636619772367581343076
#define M_2_SQRTPI 1.12837916709551257390
#define M_SQRT2    1.41421356237309504880
#define M_SQRT1_2  0.707106781186547524401
#define M_SQRT1_3  0.5773502691896257

#endif


#endif
