#include "stdafx.h"
#include "timer.hpp"

HighBaseTimer::HighBaseTimer()
{
	if(!QueryPerformanceFrequency((LARGE_INTEGER *)&this->frq))
	{
		printf("High-resolution performance counter is unavailable\n");
	}

	this->Reset();
}

void HighBaseTimer::Reset()
{
	QueryPerformanceCounter((LARGE_INTEGER *)&this->start_count);
}

double HighBaseTimer::GetElapsedSec() const
{
	__int64 now;
	QueryPerformanceCounter((LARGE_INTEGER *)&now);

	return double(now - this->start_count) / this->frq;
}



LowBaseTimer::LowBaseTimer()
{
	this->Reset();
}

void LowBaseTimer::Reset()
{
	this->start_count = GetTickCount();
}

double LowBaseTimer::GetElapsedSec() const
{
	return (GetTickCount() - this->start_count) / 1000.0;
}



Timer::Timer(int report_step):
report_step(report_step)
{
	this->sum=0.0;
	this->count=0;
}

void Timer::start()
{
	this->Reset();
}

void Timer::report()
{
	this->sum += this->GetElapsedSec();

	if(this->count == this->report_step)
	{
		std::cout << this->sum/(this->count+1) << std::endl;
		this->count = 0;
		this->sum = 0;
		return;
	}

	this->count++;
}