#ifndef TIMER_HPP
#define TIMER_HPP

#define HIGH_RESOLUTION

class HighBaseTimer
{
protected:
	__int64 frq;
	__int64 start_count;

public:
	HighBaseTimer();

	void Reset();
	double GetElapsedSec() const;
};

class LowBaseTimer
{
protected:
	DWORD start_count;

public:
	LowBaseTimer();

	void Reset();
	double GetElapsedSec() const;
};

class Timer : public
#ifdef HIGH_RESOLUTION
	HighBaseTimer
#else
	LowBaseTimer
#endif
{
protected:
	int report_step;
	double sum;
	int count;

public:
	Timer(int report_step=0);

	void start();
	void report();
};

#endif

